<?php
include('../../_core/_includes/config.php');

global $db_con;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      
    if (!isset($_FILES['zipFile'])) {
        http_response_code(400);
        echo "Nenhum arquivo enviado.";
        exit;
    }

    $file = $_FILES['zipFile'];
    if ($file['error'] !== UPLOAD_ERR_OK) {
        http_response_code(400);
        echo "Erro durante o upload do arquivo.";
        exit;
    }

    // Verifica se o arquivo enviado é de fato um ZIP
    $fileType = mime_content_type($file['tmp_name']);
    if ($fileType !== 'application/zip' && $fileType !== 'application/x-zip' && $fileType !== 'application/octet-stream') {
        http_response_code(400);
        echo "O arquivo enviado não é um arquivo .zip válido.";
        exit;
    }

    // Cria uma pasta para os arquivos extraídos se não existir
    $targetDir = '../';
    if (!file_exists($targetDir)) {
        mkdir($targetDir, 0777, true);
    }
    
    // Define o nome da pasta com base no nome do arquivo zip
    $zipFileName = pathinfo($file['name'], PATHINFO_FILENAME);
    $moduloDir = $targetDir . $zipFileName;
    if (is_dir($moduloDir)) {
        echo "Módulo já instalado.";
        exit;
    }

    $zip = new ZipArchive;
    if ($zip->open($file['tmp_name']) === TRUE) {
        $zip->extractTo($targetDir);
        $zip->close();
        
        // Após a extração, define o caminho para o arquivo SQL com base no nome do arquivo zip
        $sqlFile = $moduloDir . '/' . $zipFileName . '.sql';
        
        if (file_exists($sqlFile)) {
            $sql = file_get_contents($sqlFile);

            // Lê o arquivo menu.txt e grava seu conteúdo em menu.php
            $menuTxt = $moduloDir . '/menu.txt';
            $menuPhp = '../inicio/menu.php';
            if (file_exists($menuTxt)) {
                $menuContent = file_get_contents($menuTxt);
                if (file_put_contents($menuPhp, $menuContent, FILE_APPEND) !== false) {
                    echo "Conteúdo do menu.txt gravado com sucesso em menu.php.<br />";
                } else {
                    echo "\nErro ao gravar menu.php.";
                }
            } else {
                echo "\nArquivo menu.txt não encontrado.";
            }

            // Lê o arquivo data.txt e grava seu conteúdo em data.php
            $dataTxt = $moduloDir . '/' . $zipFileName . '.txt';
            $dataPhp = '../../_core/_includes/functions/data2.php';
            if (file_exists($dataTxt)) {
                $dataContent = file_get_contents($dataTxt);
                if (file_put_contents($dataPhp, $dataContent, FILE_APPEND) !== false) {
                    echo "Conteúdo do data.txt gravado com sucesso em data.php. <br />";
                } else {
                    echo "Erro ao gravar data.php.";
                }
            } else {
                echo "Arquivo data.txt não encontrado.";
            }

            // Conexão com o banco de dados - ajuste as credenciais conforme necessário
            $con = new PDO('mysql:host=' . $db_host . ';dbname=' . $db_name, $db_user, $db_pass);
            $con->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            if (!$con) {
                http_response_code(500);
                echo "Falha na conexão com o banco: " . implode(", ", $con->errorInfo());
                exit;
            }

            // Executa os comandos SQL (suporta múltiplas queries)
            $stmt = $con->prepare($sql);
            if ($stmt->execute()) {
                echo " Módulo instalado com sucesso.";
            } else {
                echo " Erro ao executar SQL: " . implode(", ", $stmt->errorInfo());
            }
            $con = null;
        } else {
            echo " Arquivo de banco de dados não encontrado.";
        }
    } else {
        http_response_code(500);
        echo "Falha ao extrair o arquivo zip.";
    }

} else {
    http_response_code(405);
    echo "Método não permitido.";
}
?>