<?php
// CORE
include('../../_core/_includes/config.php');
// RESTRICT
restrict_estabelecimento();
restrict_expirado();
// SEO
$seo_subtitle = "MÓDULOS";
$seo_description = "";
$seo_keywords = "";
// HEADER
$system_header .= "";
include('../_layout/head.php');
include('../_layout/top.php');
include('../_layout/sidebars.php');
include('../_layout/modal.php');
?>
<div class="middle minfit bg-gray">

	<div class="container">

		<div class="row">

			<div class="col-md-12">

				<div class="title-icon pull-left">
					<i class="lni lni-radio-button"></i>
					<span>Módulos</span>
				</div>

				<div class="bread-box pull-right">
					<div class="bread">
						<a href="<?php panel_url(); ?>"><i class="lni lni-home"></i></a>
						<span>/</span>
						<a href="<?php panel_url(); ?>/modulos">Módulos</a>
					</div>
				</div>

			</div>

		</div>
	
	

	</div>
	
	<div class="container text-center justify-content-center mx-auto mt-5">
        
        <form id="uploadForm" enctype="multipart/form-data">
            <div class="form-group text-center">
                
                
                <label for="zipFile">Selecione o arquivo do MÓDULO (.Zip):</label>
                <input type="file" class="form-control form-control-lg" id="zipFile" name="zipFile" accept=".zip" required>
            </div>
            <button type="submit" id="btnSalvar" class="btn btn-success btn-lg">Instalar Módulo</button>
        </form>
        <div id="result" class="mt-3"></div>
    </div>

</div>

    
    
    <?php 
// FOOTER
$system_footer .= "";
include('../_layout/rdp.php');
include('../_layout/footer.php');
?>

    <script>
        $(document).ready(function(){
            $("#uploadForm").on("submit", function(e){
                e.preventDefault();
                $("#btnSalvar").prop("disabled", true).text("Instalando...");
                var formData = new FormData(this);
                $.ajax({
                    xhr: function() {
                        var xhr = new window.XMLHttpRequest();
                        xhr.upload.addEventListener("progress", function(evt) {
                            if (evt.lengthComputable) {
                                var percentComplete = Math.round((evt.loaded / evt.total) * 100);
                                $("#result").html('<div class="alert bg-info alert-info" role="alert my-2">Progresso: ' + percentComplete + '%</div>');
                                setTimeout(function(){
                             $("#result").fadeOut(800);
                        },1300);
                            }else{
                                var percentComplete = Math.round((evt.loaded / evt.total) * 100);

                                $("#result").html('<div class="alert alert-warning" role="alert">Carregando...'+percentComplete+'%</div>');
                            }
                        }, false);
                        return xhr;
                    },
                    url: 'unzip.php',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(data) {
                        $("#result").html('<div class="alert alert-success my-2" role="alert">' + data + '</div>');
                        setTimeout(function(){
                             $("#result").fadeOut(800);
                             $(location).attr('href','./index.php');
                        },2500);
                        $("#btnSalvar").prop("disabled", false).text("Instalar");
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        $("#btnSalvar").prop("disabled", false).text("Instalar");
                        console.error("Erro:", textStatus, errorThrown);
                        $("#result").html('<div class="alert alert-danger my-2" role="alert">Erro: ' + errorThrown + '</div>');
                        setTimeout(function(){
                             $("#result").fadeOut(800);
                             $(location).attr('href','./index.php');
                        },2500);
                    }
                });
            });
        });
    </script>
</body>
</html>