<?php 

use HeadlessChromium\BrowserFactory;

// Log inicial
echo "Iniciando script...\n";

$browserFactory = new BrowserFactory();

echo "Criando instância do navegador...\n";

// Tenta iniciar o navegador headless
try {
    $browser = $browserFactory->createBrowser();
    echo "Navegador criado com sucesso!\n";

    // Tenta criar uma nova página e navegar até a URL
    try {
        echo "Criando nova página...\n";
        $page = $browser->createPage();
        echo "Página criada com sucesso!\n";

        echo "Navegando para http://example.com...\n";
        $page->navigate('http://example.com')->waitForNavigation();
        echo "Navegação bem-sucedida!\n";

        // Obtém o título da página
        echo "Obtendo título da página...\n";
        $pageTitle = $page->evaluate('document.title')->getReturnValue();
        echo "Título da página: $pageTitle\n";

        // Salva uma captura de tela
        echo "Tirando captura de tela...\n";
        $page->screenshot()->saveToFile('/foo/bar.png');
        echo "Captura de tela salva em /foo/bar.png\n";

        // Gera um PDF
        echo "Gerando PDF...\n";
        $page->pdf(['printBackground' => false])->saveToFile('/foo/bar.pdf');
        echo "PDF salvo em /foo/bar.pdf\n";

    } catch (Exception $e) {
        echo "Erro ao manipular a página: " . $e->getMessage() . "\n";
    }

} catch (Exception $e) {
    echo "Erro ao criar navegador: " . $e->getMessage() . "\n";
} finally {
    echo "Fechando navegador...\n";
    if (isset($browser)) {
        $browser->close();
    }
    echo "Script finalizado.\n";
}
