<?php
include('../../../_core/_includes/config.php');
restrict_estabelecimento();
restrict_expirado();
$subtitle = "Deletar Selecionados";

// Obter os IDs dos produtos a serem deletados (passados pela URL)
$ids = isset($_GET['ids']) ? $_GET['ids'] : '';
$eid = $_SESSION['estabelecimento']['id'];

if ($ids) {
    // Transformar a string de IDs em um array
    $ids_array = explode(',', $ids);

    // Verificar se os produtos pertencem ao estabelecimento
    $id_placeholder = implode(',', array_fill(0, count($ids_array), '?'));
    $query = "SELECT * FROM produtos WHERE id IN ($id_placeholder) AND rel_estabelecimentos_id = ?";
    $stmt = mysqli_prepare($db_con, $query);
    $params = array_merge($ids_array, [$eid]);
    mysqli_stmt_bind_param($stmt, str_repeat('i', count($params)), ...$params);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    // Verificar se todos os produtos pertencem ao mesmo estabelecimento
    $cando = (mysqli_num_rows($result) === count($ids_array));

    if ($cando) {
        // Deletar os produtos
        if (delete_produtos($ids_array)) {
            header("Location: ../index.php?msg=sucesso");
        } else {
            header("Location: ../index.php?msg=erro");
        }
    } else {
        header("Location: ../index.php?msg=erro");
    }
} else {
    header("Location: ../index.php?msg=erro");
}
?>
