<?php
// CORE
include('../../../_core/_includes/config.php');
// RESTRICT
restrict_estabelecimento();
restrict_expirado();
// SEO
$seo_subtitle = "Editar Contas a Pagar";
$seo_description = "";
$seo_keywords = "";
// HEADER
$system_header .= "";
include('../../_layout/head.php');
include('../../_layout/top.php');
include('../../_layout/sidebars.php');
include('../../_layout/modal.php');
?>

<?php

  // Globals

  global $numeric_data;
  $eid = $_SESSION['estabelecimento']['id'];

  $id = mysqli_real_escape_string( $db_con, $_GET['id'] );
  $edit = mysqli_query( $db_con, "SELECT * FROM pagar WHERE id = '$id' AND estabelecimento_id = '$eid' ");
  $hasdata = mysqli_num_rows( $edit );
  $data = mysqli_fetch_array( $edit );

  // Checar se formulário foi executado

  $formdata = $_POST['formdata'];

  if( $formdata ) {

    // Setar campos

   $estabelecimento = $_SESSION['estabelecimento']['id'];
    $nome = mysqli_real_escape_string( $db_con, $_POST['nome'] );
    $descricao = mysqli_real_escape_string( $db_con, $_POST['descricao'] );
    $valor = dinheiro( mysqli_real_escape_string( $db_con, $_POST['valor'] ) );
    if( !$valor ) {
      $valor = "0.00";
    }
    $data = datausa_min( mysqli_real_escape_string( $db_con, $_POST['data'] ) );
    $hora = mysqli_real_escape_string( $db_con, $_POST['hora'] );
    $status =  mysqli_real_escape_string( $db_con, $_POST['status'] );

    // Checar Erros

    $checkerrors = 0;
    $errormessage = array();

      // -- Estabelecimento

      if( !$estabelecimento ) {
        $checkerrors++;
        $errormessage[] = "O estabelecimento não pode ser nulo";
      }

      // -- Nome

      if( !$nome ) {
        $checkerrors++;
        $errormessage[] = "O nome não pode ser nulo";
      }
      
     

      if( !$descricao ) {
        $checkerrors++;
        $errormessage[] = "Coloque a descrição";
      }

      // -- Estabelecimento

     
    // Executar registro

    if( !$checkerrors ) {

      if( edit_pagar( $id,$eid,$nome,$descricao,$valor,$data,$hora,$status) ) {

        header("Location: index.php?msg=sucesso&id=".$id);

      } else {

        header("Location: index.php?msg=erro&id=".$id);

      }

    }

  }
  
?>

<div class="middle minfit bg-gray">

	<div class="container">

		<div class="row">

			<div class="col-md-12">

        <div class="title-icon pull-left">
          <i class="lni lni-radio-button"></i>
          <span>Editar Contas a Pagar</span>
        </div>

        <div class="bread-box pull-right">
          <div class="bread">
            <a href="<?php panel_url(); ?>"><i class="lni lni-home"></i></a>
            <span>/</span>
            <a href="<?php panel_url(); ?>/pagar">Contas a Pagar</a>
            <span>/</span>
            <a href="<?php panel_url(); ?>/pagar/editar?id=<?php echo $id; ?>">Editar</a>
          </div>
        </div>

			</div>

		</div>

		<!-- Content -->

		<div class="data box-white mt-16">

      <?php if( $hasdata ) { ?>

     <form id="the_form" class="form-default" method="POST" enctype="multipart/form-data" novalidate="novalidate">

          <div class="row">

            <div class="col-md-12">

              <?php if( $checkerrors ) { list_errors(); } ?>

              <?php if( $_GET['msg'] == "erro" ) { ?>

                <?php modal_alerta("Erro, tente novamente!","erro"); ?>

              <?php } ?>

              <?php if( $_GET['msg'] == "sucesso" ) { ?>

                <?php modal_alerta("Cadastro efetuado com sucesso!","sucesso"); ?>

              <?php } ?>
              
              
            </div>

          </div>

          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

               <label>Nome:</label>
                  <div class="fake-select">
                    <i class="lni lni-chevron-down"></i>
                    <select id="input-nome" name="nome">

                      <option value="<?php echo htmlclean($data['cliente']);  ?>"><?php echo htmlclean($data['cliente']);  ?></option>

                      <?php
                        $tipo1=2;
                      $query2="SELECT nome,doc FROM crm WHERE estabelecimento_id='$eid' AND contato='$tipo1' ";
                      $sql2 = mysqli_query( $db_con, $query2 );
                      //$data = mysqli_fetch_array( $sql );
                      //$total = count( $data );

                          while ( $data2 = mysqli_fetch_array( $sql2 ) ){
                      
                      ?>

                      <option value="<?php echo htmlclean($data2['nome']); ?>"><?php echo htmlclean($data2['nome']).' '.htmlclean($data2['doc']); ?></option>

                      <?php } ?>
                      
                      
                      
                    </select>
                    <div class="clear"></div>
                  </div>
              </div>

            </div>
          
          </div>
          
          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

                  <label>Descrição:</label>
                  <input type="text" name="descricao" placeholder="Descrição" value="<?php echo htmlclean( $data['descricao'] ); ?>">

              </div>

            </div>

          </div>

          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

                  <label>Valor:</label>
                  <input class="maskmoney" type="text" name="valor" placeholder="Valor" value="<?php echo dinheiro( $data['valor'],"BR" ); ?>">

              </div>

            </div>

          </div>
          
          <div class="row">

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Validade (data):</label>
                  <input class="maskdate" type="text" name="data" placeholder="Validade (data)" value="<?php echo databr_min( $data['data'] ); ?>">

              </div>

            </div>

            <div class="col-md-6">

              <div class="form-field-default">

                    <label>Validade (hora):</label>
                  <input class="masktimemin" type="text" name="hora" placeholder="Validade (hora)" value="<?php echo htmlclean( $data['hora'] ); ?>">

              </div>

            </div>

          </div>
          
          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

                  <label>Paga?</label>
                  <div class="radios">
                    <div class="spacer"></div>
                    <div class="form-field-radio">
                      <input type="radio" name="status" value="1" <?php if( $data['status'] == 1 OR !$data['status'] ){ echo 'checked'; }; ?>>Não
                    </div>
                    <div class="form-field-radio">
                      <input type="radio" name="status" value="2" <?php if( $data['status'] == 2 ){ echo 'checked'; }; ?>>Sim
                    </div>
                    <div class="clear"></div>
                  </div>

              </div>

            </div>

          </div>

          <div class="row lowpadd">

            <div class="col-md-6 col-sm-5 col-xs-5">
              <div class="form-field form-field-submit">
                <a href="<?php panel_url(); ?>/pagar" class="backbutton pull-left">
                  <span><i class="lni lni-chevron-left"></i> Voltar</span>
                </a>
              </div>
            </div>

            <div class="col-md-6 col-sm-7 col-xs-7">
              <input type="hidden" name="formdata" value="true">
              <div class="form-field form-field-submit">
                <button class="pull-right">
                  <span>Salvar <i class="lni lni-chevron-right"></i></span>
                </button>
              </div>
            </div>

          </div>

      </form>

      <?php } else { ?>

        <span class="nulled nulled-edit color-red">Erro, inválido ou não encontrado!</span>

      <?php } ?>

		</div>

		<!-- / Content -->

	</div>

</div>

<?php 
// FOOTER
$system_footer .= "";
include('../../_layout/rdp.php');
include('../../_layout/footer.php');
?>

<script>

$(document).ready( function() {
          
  // Globais

  $("#the_form").validate({

      /* REGRAS DE VALIDAÇÃO DO FORMULÁRIO */

      rules:{

       
        nome:{
        required: true
        }

      },
          
      /* DEFINIÇÃO DAS MENSAGENS DE ERRO */
              
      messages:{

        
        nome:{
          required: "Esse campo é obrigatório"
        }

      }

    });

  });

</script>