<?php
// CORE
include('../../../_core/_includes/config.php');
// RESTRICT
restrict_estabelecimento();
restrict_expirado();
// SEO
$seo_subtitle = "Entregadores";
$seo_description = "";
$seo_keywords = "";
// HEADER
$system_header .= "";
include('../../_layout/head.php');
include('../../_layout/top.php');
include('../../_layout/sidebars.php');
include('../../_layout/modal.php');
?>

<?php

  // Globals

  global $numeric_data;

  $estabelecimento = $_SESSION['estabelecimento']['id'];
  // Checar se formulário foi executado

  $formdata = $_POST['formdata'];

  if( $formdata ) {

    // Setar campos

    
    $nome = mysqli_real_escape_string( $db_con, $_POST['nome'] );
    $celular = mysqli_real_escape_string( $db_con, $_POST['celular'] );
    $email = mysqli_real_escape_string( $db_con, $_POST['email'] );
    $tipo = mysqli_real_escape_string( $db_con, $_POST['tipo'] );
    $documento = mysqli_real_escape_string( $db_con, $_POST['documento'] );
    $estado = mysqli_real_escape_string( $db_con, $_POST['estado'] );
    $cidade = mysqli_real_escape_string( $db_con, $_POST['cidade'] );
    $remuneracao = mysqli_real_escape_string( $db_con, $_POST['remuneracao'] );
    $valor =dinheiro( mysqli_real_escape_string( $db_con, $_POST['valor'] ) );
    if( !$valor ) {
      $valor = "0.00";
    }    
    $senha = mysqli_real_escape_string( $db_con, $_POST['pass'] );
    $nascimento = datausa_min(mysqli_real_escape_string( $db_con, $_POST['nascimento'] ));
    
    

    // Checar Erros

    $checkerrors = 0;
    $errormessage = array();

      // -- Estabelecimento

      if( !$estabelecimento ) {
        $checkerrors++;
        $errormessage[] = "O estabelecimento não pode ser nulo";
      }

      // -- Nome

      if( !$nome ) {
        $checkerrors++;
        $errormessage[] = "O nome não pode ser nulo";
      }     

    // Executar registro

    if( !$checkerrors ) {

      if( new_entregador( $estabelecimento,$nome,$celular,$email,$tipo,$documento,$estado,$cidade,$remuneracao,$valor,$nascimento,$senha ) ) {

        header("Location: index.php?msg=sucesso");

      } else {

        header("Location: index.php?msg=erro");

      }

    }

  }
  
?>

<div class="middle minfit bg-gray">

	<div class="container">

		<div class="row">

			<div class="col-md-12">

        <div class="title-icon pull-left">
          <i class="lni lni-radio-button"></i>
          <span>Adicionar Entregadores</span>
        </div>

        <div class="bread-box pull-right">
          <div class="bread">
            <a href="<?php panel_url(); ?>"><i class="lni lni-home"></i></a>
            <span>/</span>
            <a href="<?php panel_url(); ?>/entregadores">Entregadores</a>
            <span>/</span>
            <a href="<?php panel_url(); ?>/entregadores/adicionar">Adicionar</a>
          </div>
        </div>
        
			</div>

		</div>

		<!-- Content -->

		<div class="data box-white mt-16">

      

      <form id="the_form" class="form-default" method="POST" enctype="multipart/form-data" novalidate="novalidate">

          <div class="row">

            <div class="col-md-12">

              <?php if( $checkerrors ) { list_errors(); } ?>

              <?php if( $_GET['msg'] == "erro" ) { ?>

                <?php modal_alerta("Erro, tente novamente!","erro"); ?>

              <?php } ?>

              <?php if( $_GET['msg'] == "sucesso" ) { ?>

                <?php modal_alerta("Cadastro efetuado com sucesso!","sucesso"); ?>

              <?php } ?>
              
              
            </div>

          </div>

          <div class="row">
            <div class="col-md-12">
              <div class="title-line mt-0 pd-0">
              <i class="lni lni-user"></i>
              <span>Dados gerais</span>
              <div class="clear"></div>
              </div>
            </div>
          </div>

          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

                  <label>Nome:</label>
                  <input type="text" id="input-nome" name="nome" placeholder="Nome" value="<?php echo htmlclean( $_POST['nome'] ); ?>">

              </div>

            </div>

          </div>

          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

                  <label>Data Nascimento:</label>

                  <input type="text" class="maskdate" id="input-nascimento" name="nascimento" placeholder="Data de nascimento" value="<?php echo databr_min( $_POST['nascimento'] ); ?>">

              </div>

            </div>

           

          </div>
          
          <div class="row">

            <div class="col-md-6">

              <div class="form-field-default">

                    <label>Tipo de documento:</label>
                    <div class="fake-select">
                    <i class="lni lni-chevron-down"></i>
                    <select id="input-documento_tipo" name="tipo">
                    <option></option>
                    <option value="1">CPF</option>
                    <option value="2">CNPJ</option>
                    </select>
                    <div class="clear"></div>
                    </div>
                

              </div>

            </div>
         
            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Nº do documento:</label>
                  <input type="text" id="input-documento" name="documento" placeholder="Nº do documento" value="<?php echo htmlclean( $_POST['documento'] ); ?>">

              </div>

            </div>

          </div>
          
          <div class="row">

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Estado:</label>
                  <div class="fake-select">
                    <i class="lni lni-chevron-down"></i>
                    <select id="input-estado" name="estado">

                        <option value="">Estado</option>
                        
                          <option value="1">Acre</option>

                        
                          <option value="2">Alagoas</option>

                        
                          <option value="4">Amapá</option>

                        
                          <option value="3">Amazonas</option>

                        
                          <option value="5">Bahia</option>

                        
                          <option value="6">Ceará</option>

                        
                          <option value="7">Distrito Federal</option>

                        
                          <option value="8">Espírito Santo</option>

                        
                          <option value="9">Goiás</option>

                        
                          <option value="10">Maranhão</option>

                        
                          <option value="13">Mato Grosso</option>

                        
                          <option value="12">Mato Grosso do Sul</option>

                        
                          <option value="11">Minas Gerais</option>

                        
                          <option value="14">Pará</option>

                        
                          <option value="15">Paraíba</option>

                        
                          <option value="18">Paraná</option>

                        
                          <option value="16">Pernambuco</option>

                        
                          <option value="17">Piauí</option>

                        
                          <option value="19">Rio de Janeiro</option>

                        
                          <option value="20">Rio Grande do Norte</option>

                        
                          <option value="23">Rio Grande do Sul</option>

                        
                          <option value="21">Rondônia</option>

                        
                          <option value="22">Roraima</option>

                        
                          <option value="24">Santa Catarina</option>

                        
                          <option value="26">São Paulo</option>

                        
                          <option value="25">Sergipe</option>

                        
                          <option value="27">Tocantins</option>

                        
                    </select>
                    <div class="clear"></div>
                </div>

              </div>

            </div>

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Cidade:</label>
                  <div class="fake-select">
                    <i class="lni lni-chevron-down"></i>
                    <select id="input-cidade" name="cidade">

                        <option value="">Cidade</option>

                    </select>
                    <div class="clear"></div>
                </div>

              </div>

            </div>

          </div>
          
          

          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

                  <label>Celular:</label>

                  <input type="text" class="maskcel" id="input-telefone" name="celular" placeholder="Celular" value="<?php echo htmlclean( $_POST['celular'] ); ?>">

              </div>

            </div>

            
          </div>

          <div class="row">
            <div class="col-md-12">
              <div class="form-field-default">
              <label>Tipo de remuneração:</label>
                  <div class="fake-select">
                  <i class="lni lni-chevron-down"></i>
                  <select id="input-remuneracao_tipo" name="remuneracao">
                  <option></option>
                  <option value="1">Taxa de entrega da região/bairro</option>
                  <option value="2">Taxa fixa por entrega</option>
                  <option value="3">À combinar</option>
                  </select>
                  <div class="clear"></div>
                  </div>
              
              </div>
            </div>
          </div>

          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

                  <span class="form-tip">Se optar pela taxa fixa, insira o valor que o entregador receberá por entrega.</span>

                  <input type="text" name="valor" placeholder="Valor da taxa fixa" class="maskmoney" value="<?php echo htmlclean( $_POST['valor'] ); ?>">

              </div>

            </div>            
        
          </div>


          <div class="row">
            <div class="col-md-12">
              <div class="title-line">
                <i class="lni lni-lock"></i>
                <span>Dados de acesso</span>
                <div class="clear"></div>
              </div>
            </div>
          </div>
          
          <div class="row">

            
            <div class="col-md-12">

              <div class="form-field-default">

                  <label>E-mail:</label>
                  <input type="text" id="input-email" name="email" placeholder="E-mail"  class="error" value="<?php echo htmlclean( $_POST['email'] ); ?>">
                  <label for="input-email" generated="true" class="error">E-mail já registrado no sistema, por favor escolha outro!</label>

              </div>

            </div>
        
          </div>
          
          <div class="row">

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Senha:</label>
                  <input type="password" id="input-pass" name="pass" placeholder="Senha" class="valid" value="<?php echo htmlclean( $_POST['pass'] ); ?>">

              </div>

            </div>

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Repita a Senha:</label>
                  <input type="password" id="input-repass" name="repass" placeholder="Redigite sua senha">

              </div>

            </div>


          </div>

          

          <div class="row lowpadd">

            <div class="col-md-6 col-sm-5 col-xs-5">
              <div class="form-field form-field-submit">
                <a href="<?php  panel_url();  ?>/entregadores" class="backbutton pull-left">
                  <span><i class="lni lni-chevron-left"></i> Voltar</span>
                </a>
              </div>
            </div>

            <div class="col-md-6 col-sm-7 col-xs-7">
              <input type="hidden" name="formdata" value="true">
              <div class="form-field form-field-submit">
                <button class="pull-right">
                  <span>Cadastrar <i class="lni lni-chevron-right"></i></span>
                </button>
              </div>
            </div>

          </div>

      </form>

		</div>

		<!-- / Content -->

	</div>

</div>

<?php 
// FOOTER
$system_footer .= "";
include('../../_layout/rdp.php');
include('../../_layout/footer.php');
?>

<script>

  function exibe_cidades() {
    var estado = $("#input-estado").children("option:selected").val();
    $("#input-cidade").html("<option>-- Carregando cidades --</option>");
    $("#input-cidade").load("<?php just_url();  ?>/_core/_ajax/cidades.php?cidade=&estado="+estado);
  }

  // Autopreenchimento de estado
  $( "#input-estado" ).change(function() {
    exibe_cidades();
  });
  
</script>

<script>

$(document).ready( function() {
          
  $("#the_form").validate({

      /* REGRAS DE VALIDAÇÃO DO FORMULÁRIO */

      rules:{

        nome:{
        required: true
        },

        email:{
        required: true,
        minlength: 5,
        maxlength: 100,
        email: true,
        remote: "<?php just_url();  ?>/_core/_ajax/check_email.php"
        },

        pass:{
        required: true,
        minlength: 6,
        maxlength: 40
        },

        repass:{
        required: true,
        minlength: 6,
        maxlength: 40,
        equalTo: "input[name=pass]"
        }

      },
          
      /* DEFINIÇÃO DAS MENSAGENS DE ERRO */
              
      messages:{

        nome:{
          required: "Esse campo é obrigatório"
        },

        email:{
          email: "Por favor escolha um e-mail válido!",
          remote: "E-mail já registrado no sistema, por favor escolha outro!",
          required: "Este campo é obrigatório!",
          minlength: "Mínimo de 5 caracteres",
          maxlength: "Maximo de 40 caracteres"
        },

        pass:{
          required: "Este campo é obrigatório!",
          minlength: "Mínimo 6 caracteres",
          maxlength: "Maximo 40 caracteres"
        },

        repass:{
          required: "Este campo é obrigatório!",
          minlength: "Mínimo 6 caracteres",
          maxlength: "Maximo 40 caracteres",
          equalTo: "Senhas não coincidem!"
        }

      }

  });

});

</script>