<?php
// CORE
include('../../../_core/_includes/config.php');
// RESTRICT
restrict_estabelecimento();
restrict_expirado();
// SEO
$seo_subtitle = "Editar Clientes e Fornecedores";
$seo_description = "";
$seo_keywords = "";
// HEADER
$system_header .= "";
include('../../_layout/head.php');
include('../../_layout/top.php');
include('../../_layout/sidebars.php');
include('../../_layout/modal.php');
?>

<?php

  // Globals

  global $numeric_data;
  $eid = $_SESSION['estabelecimento']['id'];

  $id = mysqli_real_escape_string( $db_con, $_GET['id'] );
  $edit = mysqli_query( $db_con, "SELECT * FROM crm WHERE id = '$id' AND estabelecimento_id = '$eid' LIMIT 1");
  $hasdata = mysqli_num_rows( $edit );
  $data = mysqli_fetch_array( $edit );

  // Checar se formulário foi executado

  $formdata = $_POST['formdata'];

  if( $formdata ) {

    // Setar campos

    $estabelecimento = $_SESSION['estabelecimento']['id'];
    $nome = mysqli_real_escape_string( $db_con, $_POST['nome'] );
    $whatsapp = mysqli_real_escape_string( $db_con, $_POST['whatsapp'] );
    $email = mysqli_real_escape_string( $db_con, $_POST['email'] );

    $tipo = mysqli_real_escape_string( $db_con, $_POST['tipo'] );
    $documento = mysqli_real_escape_string( $db_con, $_POST['documento'] );
    $estado = mysqli_real_escape_string( $db_con, $_POST['estado'] );
    $cidade = mysqli_real_escape_string( $db_con, $_POST['cidade'] );
    $cep = mysqli_real_escape_string( $db_con, $_POST['endereco_cep'] );
    $numero = mysqli_real_escape_string( $db_con, $_POST['endereco_numero'] );
    $bairro = mysqli_real_escape_string( $db_con, $_POST['endereco_bairro'] );
    $rua = mysqli_real_escape_string( $db_con, $_POST['endereco_rua'] );
    $contato = mysqli_real_escape_string( $db_con, $_POST['contato_tipo'] );

    $nascimento = datausa_min(mysqli_real_escape_string( $db_con, $_POST['nascimento'] ));
    $descricao = mysqli_real_escape_string( $db_con, $_POST['descricao'] );

    // Checar Erros

    $checkerrors = 0;
    $errormessage = array();

      // -- Estabelecimento

      if( !$estabelecimento ) {
        $checkerrors++;
        $errormessage[] = "O estabelecimento não pode ser nulo";
      }

      // -- Nome

      if( !$nome ) {
        $checkerrors++;
        $errormessage[] = "O nome não pode ser nulo";
      }
      
      // -- Nome

     
    // Executar registro

    if( !$checkerrors ) {

      if( edit_crm( $id,$eid,$nome,$whatsapp,$email,$tipo,$documento,$estado,$cidade,$cep,$numero,$bairro,$rua,$contato,$nascimento,$descricao ) ) {

        header("Location: index.php?msg=sucesso&id=".$id);

      } else {

        header("Location: index.php?msg=erro&id=".$id);

      }

    }

  }
  
?>

<div class="middle minfit bg-gray">

	<div class="container">

		<div class="row">

			<div class="col-md-12">

        <div class="title-icon pull-left">
          <i class="lni lni-radio-button"></i>
          <span>Editar Clientes e Fornecedores</span>
        </div>

        <div class="bread-box pull-right">
          <div class="bread">
            <a href="<?php panel_url(); ?>"><i class="lni lni-home"></i></a>
            <span>/</span>
            <a href="<?php panel_url(); ?>/crm">Clientes e Fornecedores</a>
            <span>/</span>
            <a href="<?php panel_url(); ?>/crm/editar?id=<?php echo $id; ?>">Editar</a>
          </div>
        </div>

			</div>

		</div>

		<!-- Content -->

		<div class="data box-white mt-16">

      <?php if( $hasdata ) { ?>

      


      <form id="the_form" class="form-default" method="POST" enctype="multipart/form-data" novalidate="novalidate">

          <div class="row">

            <div class="col-md-12">

              <?php if( $checkerrors ) { list_errors(); } ?>

              <?php if( $_GET['msg'] == "erro" ) { ?>

                <?php modal_alerta("Erro, tente novamente!","erro"); ?>

              <?php } ?>

              <?php if( $_GET['msg'] == "sucesso" ) { ?>

                <?php modal_alerta("Cadastro efetuado com sucesso!","sucesso"); ?>

              <?php } ?>
              
              
            </div>

          </div>

          <div class="row">

            <div class="col-md-12">

              <div class="form-field-default">

                  <label>Nome:</label>
                  <input type="text" id="input-nome" name="nome" placeholder="Nome" value="<?php echo htmlclean( $data['nome'] ); ?>">

              </div>

            </div>

          </div>

          <div class="row">

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Celular:</label>

                  <input class="maskcel" type="text" name="whatsapp" placeholder="Celular" value="<?php echo htmlclean( $data['celular'] ); ?>">

              </div>

            </div>

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Email:</label>
                  
                  <input type="text" name="email" placeholder="Email" value="<?php echo htmlclean( $data['email'] ); ?>">


              </div>

            </div>

          </div>
          
          <div class="row">

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Tipo de documento:</label>
                  <div class="fake-select">
                    <i class="lni lni-chevron-down"></i>
                    <select id="input-documento_tipo" name="tipo">
                      <option value="<?php echo $data['tipo'];  ?>"><?php if($data['tipo']==1){ echo "CPF"; }else if($data['tipo']==2){echo "CNPJ"; }  ?></option>
                      <option value="1">CPF</option>
                      <option value="2">CNPJ</option>
                    </select>
                    <div class="clear"></div>
                </div>

              </div>

            </div>
         
            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Nº do documento:</label>
                  <input type="text" id="input-documento" name="documento" placeholder="Nº do documento" value="<?php echo htmlclean( $data['doc'] ); ?>">

              </div>

            </div>

          </div>
          
          <div class="row">

            <div class="col-md-6">

              <div class="form-field-default">
                  
                  <?php
                    
                    $uf=$data['estado'];
                    $cid=$data['cidade'];
                    
                    $buscauf=mysqli_query($db_con,"SELECT * FROM estados WHERE id='$uf'");
                    $dadosuf=mysqli_fetch_array($buscauf);
                    
                    $buscacid=mysqli_query($db_con,"SELECT * FROM cidades WHERE id='$cid' and estado='$uf'");
                    $dadoscid=mysqli_fetch_array($buscacid);
                  
                  ?>

                  <label>Estado:</label>
                  <div class="fake-select">
                    <i class="lni lni-chevron-down"></i>
                    <select id="input-estado" name="estado">

                        <option value="<?php echo $dadosuf['id'];  ?>"><?php echo $dadosuf['nome'];  ?></option>
                        
                          <option value="1">Acre</option>

                        
                          <option value="2">Alagoas</option>

                        
                          <option value="4">Amapá</option>

                        
                          <option value="3">Amazonas</option>

                        
                          <option value="5">Bahia</option>

                        
                          <option value="6">Ceará</option>

                        
                          <option value="7">Distrito Federal</option>

                        
                          <option value="8">Espírito Santo</option>

                        
                          <option value="9">Goiás</option>

                        
                          <option value="10">Maranhão</option>

                        
                          <option value="13">Mato Grosso</option>

                        
                          <option value="12">Mato Grosso do Sul</option>

                        
                          <option value="11">Minas Gerais</option>

                        
                          <option value="14">Pará</option>

                        
                          <option value="15">Paraíba</option>

                        
                          <option value="18">Paraná</option>

                        
                          <option value="16">Pernambuco</option>

                        
                          <option value="17">Piauí</option>

                        
                          <option value="19">Rio de Janeiro</option>

                        
                          <option value="20">Rio Grande do Norte</option>

                        
                          <option value="23">Rio Grande do Sul</option>

                        
                          <option value="21">Rondônia</option>

                        
                          <option value="22">Roraima</option>

                        
                          <option value="24">Santa Catarina</option>

                        
                          <option value="26">São Paulo</option>

                        
                          <option value="25">Sergipe</option>

                        
                          <option value="27">Tocantins</option>

                        
                    </select>
                    <div class="clear"></div>
                </div>

              </div>

            </div>

            <div class="col-md-6">

              <div class="form-field-default">

                  <label>Cidade:</label>
                  <div class="fake-select">
                    <i class="lni lni-chevron-down"></i>
                    <select id="input-cidade" name="cidade">

                        <option value="<?php echo $dadoscid['id'];  ?>"><?php echo $dadoscid['nome'];  ?></option>

                    </select>
                    <div class="clear"></div>
                </div>

              </div>

            </div>

          </div>
          
          <div class="elemento-endereco">

              <div class="row">

                <div class="col-md-6 col-sm-6 col-xs-6">

                  <div class="form-field-default">

                      <label>CEP:</label>

                      <input class="maskcep" type="text" name="endereco_cep" placeholder="CEP" value="<?php echo htmlclean( $data['cep'] ); ?>">

                  </div>

                </div>

                <div class="col-md-6 col-sm-6 col-xs-6">

                  <div class="form-field-default">

                      <label>Nº:</label>

                      <input type="text" name="endereco_numero" placeholder="Nº" value="<?php echo htmlclean( $data['numero'] ); ?>">

                  </div>

                </div>

              </div>

              <div class="row">

                <div class="col-md-6">

                  <div class="form-field-default">

                      <label>Bairro:</label>

                      <input type="text" name="endereco_bairro" placeholder="Bairro" value="<?php echo htmlclean( $data['bairro'] ); ?>">

                  </div>

                </div>

                <div class="col-md-6">

                  <div class="form-field-default">

                      <label>Rua:</label>

                      <input type="text" name="endereco_rua" placeholder="Rua" value="<?php echo htmlclean( $data['rua'] ); ?>">

                  </div>

                </div>
            
              </div>
              
              <div class="row">

                <div class="col-md-6">

                  <div class="form-field-default">

                      <label>Tipo de contato:</label>
                      <div class="fake-select">
                        <i class="lni lni-chevron-down"></i>
                        <select id="input-documento_tipo" name="contato_tipo">
                          <option value="<?php echo $data['tipo'];  ?>"><?php if($data['tipo']==1){ echo "Cliente"; }else if($data['tipo']==2){echo "Fornecedor"; }  ?></option>
                          <option value="1">Cliente</option>
                          <option value="2">Fornecedor</option>
                        </select>
                        <div class="clear"></div>
                        
                    </div>

                  </div>

                </div>

                <div class="col-md-6">

                  <div class="form-field-default">

                      <label>Data de nascimento:</label>
                      <input type="text" class="maskdate" id="input-nascimento" name="nascimento" placeholder="Data de nascimento" value="<?php echo databr_min( $data['nascimento'] ); ?>">

                  </div>

                </div>
            
              </div>
              
              <div class="row">

                <div class="col-md-12">

                  <div class="form-field-default">

                      <label>Observação:</label>
                      <input type="text" name="descricao" placeholder="Observação" value="<?php echo htmlclean( $data['descricao'] ); ?>">

                  </div>

                </div>

              </div>

          </div>

          <div class="row lowpadd">

            <div class="col-md-6 col-sm-5 col-xs-5">
              <div class="form-field form-field-submit">
                <a href="<?php  panel_url();  ?>/crm" class="backbutton pull-left">
                  <span><i class="lni lni-chevron-left"></i> Voltar</span>
                </a>
              </div>
            </div>

            <div class="col-md-6 col-sm-7 col-xs-7">
              <input type="hidden" name="formdata" value="true">
              <div class="form-field form-field-submit">
                <button class="pull-right">
                  <span>Salvar <i class="lni lni-chevron-right"></i></span>
                </button>
              </div>
            </div>

          </div>

      </form>

      <?php } else { ?>

        <span class="nulled nulled-edit color-red">Erro, inválido ou não encontrado!</span>

      <?php } ?>

		</div>

		<!-- / Content -->

	</div>

</div>

<?php 
// FOOTER
$system_footer .= "";
include('../../_layout/rdp.php');
include('../../_layout/footer.php');
?>

<script>

  function exibe_cidades() {
    var estado = $("#input-estado").children("option:selected").val();
    $("#input-cidade").html("<option>-- Carregando cidades --</option>");
    $("#input-cidade").load("<?php just_url();  ?>/_core/_ajax/cidades.php?cidade=&estado="+estado);
  }

  // Autopreenchimento de estado
  $( "#input-estado" ).change(function() {
    exibe_cidades();
  });
  
</script>

<script>

$(document).ready( function() {
          
  // Globais

  $("#the_form").validate({

      /* REGRAS DE VALIDAÇÃO DO FORMULÁRIO */

      rules:{

       
        nome:{
        required: true
        }

      },
          
      /* DEFINIÇÃO DAS MENSAGENS DE ERRO */
              
      messages:{

        
        nome:{
          required: "Esse campo é obrigatório"
        }

      }

    });

  });

</script>