<?php
// CORE
include('../../../_core/_includes/config.php');
// RESTRICT
restrict_estabelecimento();
restrict_expirado();
// SEO
$seo_subtitle = "Adicionar Cliente";
$seo_description = "";
$seo_keywords = "";
// HEADER
$system_header .= "";
include('../../_layout/head.php');
include('../../_layout/top.php');
include('../../_layout/sidebars.php');
include('../../_layout/modal.php');
?>
<?php

  // Globals
  global $numeric_data;

  // Checar se formulário foi executado
  $formdata = $_POST['formdata'];

 $estabelecimento = $_SESSION['estabelecimento']['id'];
  if( $formdata ) {

    // Setar campos
   
    $nome = mysqli_real_escape_string( $db_con, $_POST['nome'] );
    $whatsapp = mysqli_real_escape_string( $db_con, $_POST['whatsapp'] );
    $forma_entrega = mysqli_real_escape_string( $db_con, $_POST['forma_entrega'] );
    $endereco_cep = mysqli_real_escape_string( $db_con, $_POST['endereco_cep'] );
    $endereco_numero = mysqli_real_escape_string( $db_con, $_POST['endereco_numero'] );
    $endereco_bairro = mysqli_real_escape_string( $db_con, $_POST['endereco_bairro'] );
    $endereco_rua = mysqli_real_escape_string( $db_con, $_POST['endereco_rua'] );
    $endereco_complemento = mysqli_real_escape_string( $db_con, $_POST['endereco_complemento'] );
    $endereco_referencia = mysqli_real_escape_string( $db_con, $_POST['endereco_referencia'] );
    $ultimo_pedido = mysqli_real_escape_string( $db_con, $_POST['ultimo_pedido'] );

    // Checar Erros
    $checkerrors = 0;
    $errormessage = array();

    // -- Validação de campos obrigatórios
    if( !$estabelecimento ) {
        $checkerrors++;
        $errormessage[] = "O estabelecimento não pode ser nulo";
    }
    if( !$nome ) {
        $checkerrors++;
        $errormessage[] = "O nome não pode ser nulo";
    }
    if( !$whatsapp ) {
        $checkerrors++;
        $errormessage[] = "O WhatsApp não pode ser nulo";
    }
    

    // Executar registro
     if (!$checkerrors) {
        $query_check = "SELECT * FROM clientes_autofill WHERE whatsapp = '$whatsapp' AND id_estabelecimento = '$estabelecimento'";
        $result_check = mysqli_query($db_con, $query_check);

        if (mysqli_num_rows($result_check) > 0) {
            // Se o número já existe, faz um UPDATE
            $query_update = "UPDATE clientes_autofill SET 
                nome = '$nome', 
                forma_entrega = '$forma_entrega',
                endereco_cep = '$endereco_cep',
                endereco_numero = '$endereco_numero',
                endereco_bairro = '$endereco_bairro',
                endereco_rua = '$endereco_rua',
                endereco_complemento = '$endereco_complemento',
                endereco_referencia = '$endereco_referencia',
                ultimo_pedido = '$ultimo_pedido'
                WHERE whatsapp = '$whatsapp' AND id_estabelecimento = '$estabelecimento'";

            if (mysqli_query($db_con, $query_update)) {
                header("Location: index.php?msg=sucesso");
            } else {
                header("Location: index.php?msg=erro");
            }

        } else {
            // Se o número não existe, faz um INSERT
            $query_insert = "INSERT INTO clientes_autofill 
                (id_estabelecimento, nome, whatsapp, forma_entrega, endereco_cep, endereco_numero, endereco_bairro, endereco_rua, endereco_complemento, endereco_referencia, ultimo_pedido) 
                VALUES 
                ('$estabelecimento', '$nome', '$whatsapp', '$forma_entrega', '$endereco_cep', '$endereco_numero', '$endereco_bairro', '$endereco_rua', '$endereco_complemento', '$endereco_referencia', '$ultimo_pedido')";

            if (mysqli_query($db_con, $query_insert)) {
                header("Location: index.php?msg=sucesso");
            } else {
                header("Location: index.php?msg=erro");
            }
        }
    }
  }
?>



<div class="middle minfit bg-gray">

	<div class="container">

		<div class="row">

			<div class="col-md-12">

        <div class="title-icon pull-left">
          <i class="lni lni-radio-button"></i>
          <span>Adicionar Cliente</span>
        </div>

        <div class="bread-box pull-right">
          <div class="bread">
            <a href="<?php panel_url(); ?>"><i class="lni lni-home"></i></a>
            <span>/</span>
            <a href="<?php panel_url(); ?>/clientes">Clientes</a>
            <span>/</span>
            <a href="<?php panel_url(); ?>/clientes/adicionar">Adicionar</a>
          </div>
        </div>
        
			</div>

		</div>

		<!-- Content -->

		<div class="data box-white mt-16">

    <form id="the_form" class="form-default" method="POST" enctype="multipart/form-data">

        <div class="row">
            <div class="col-md-12">
                <?php if( $checkerrors ) { list_errors(); } ?>
                <?php if( $_GET['msg'] == "erro" ) { ?>
                    <?php modal_alerta("Erro, tente novamente!","erro"); ?>
                <?php } ?>
                <?php if( $_GET['msg'] == "sucesso" ) { ?>
                    <?php modal_alerta("Cadastro efetuado com sucesso!","sucesso"); ?>
                <?php } ?>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-field-default">
                    <label>Nome:</label>
                    <input type="text" id="input-nome" name="nome" placeholder="Nome" value="<?php echo htmlclean( $_POST['nome'] ); ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-field-default">
                    <label>WhatsApp:</label>
                    <input type="text" id="input-whatsapp" name="whatsapp" placeholder="WhatsApp" value="<?php echo htmlclean( $_POST['whatsapp'] ); ?>">
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-field-default">
                    <label>Forma de Entrega:</label>
                    <div class="fake-select">

													<i class="lni lni-chevron-down"></i>

													<select id="input-forma-entrega" name="forma_entrega">

													   <option value="">Selecione...</option>

 													  



						                              <?php 


						                              $quicksql = mysqli_query( $db_con, "SELECT * FROM frete WHERE rel_estabelecimentos_id = '$estabelecimento' AND outros = '0' ORDER BY nome ASC LIMIT 999" );

						                              while( $quickdata = mysqli_fetch_array( $quicksql ) ) {

						                              ?>



												  		<!--<option <?php //if( $_SESSION['checkout']['forma_entrega'] == $quickdata['id'] ) { echo 'SELECTED'; }; ?> value="<?php // echo $quickdata['id'] ;?>"><?php // echo htmlclean( $quickdata['nome'] ); ?> <?php // if( $quickdata['valor'] >= 0.01 ) { echo "(+ R$ ".htmlclean( dinheiro( $quickdata['valor'], "BR") ).")"; }; ?></option>-->
												  		<option <?php if( $_SESSION['checkout']['forma_entrega'] == $quickdata['id'] ) { echo 'SELECTED'; }; ?> value="<?php echo $quickdata['id'] ;?>"><?php echo htmlclean( $quickdata['nome'] ); ?></option>
				                              		

				                              		  <?php } ?>



													</select>

													<div class="clear"></div>

												</div>
                </div>
            </div>
           
            <div class="col-md-6">
                <div class="form-field-default">
                    <label>CEP:</label>
                    <input type="text" id="input-endereco_cep" name="endereco_cep" placeholder="CEP" value="<?php echo htmlclean( $_POST['endereco_cep'] ); ?>">
                </div>
            </div>
        </div>

                <!-- Outros campos de endereço -->
                
                <div class="row">
        <div class="col-md-6">
            <div class="form-field-default">
                <label>Número:</label>
                <input type="text" id="input-endereco_numero" name="endereco_numero" placeholder="Número" value="<?php echo htmlclean( $_POST['endereco_numero'] ); ?>">
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-field-default">
                <label>Bairro:</label>
                <input type="text" id="input-endereco_bairro" name="endereco_bairro" placeholder="Bairro" value="<?php echo htmlclean( $_POST['endereco_bairro'] ); ?>">
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <div class="form-field-default">
                <label>Rua:</label>
                <input type="text" id="input-endereco_rua" name="endereco_rua" placeholder="Rua" value="<?php echo htmlclean( $_POST['endereco_rua'] ); ?>">
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-field-default">
                <label>Complemento:</label>
                <input type="text" id="input-endereco_complemento" name="endereco_complemento" placeholder="Complemento" value="<?php echo htmlclean( $_POST['endereco_complemento'] ); ?>">
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <div class="form-field-default">
                <label>Referência:</label>
                <input type="text" id="input-endereco_referencia" name="endereco_referencia" placeholder="Referência" value="<?php echo htmlclean( $_POST['endereco_referencia'] ); ?>">
            </div>
        </div>
    </div>

        
        <div class="row lowpadd">
            <div class="col-md-6 col-sm-5 col-xs-5">
                <div class="form-field form-field-submit">
                    <a href="<?php panel_url(); ?>/clientes_autofill" class="backbutton pull-left">
                        <span><i class="lni lni-chevron-left"></i> Voltar</span>
                    </a>
                </div>
            </div>
            <div class="col-md-6 col-sm-7 col-xs-7">
                <input type="hidden" name="formdata" value="true"/>
                <div class="form-field form-field-submit">
                    <button class="pull-right">
                        <span>Cadastrar <i class="lni lni-chevron-right"></i></span>
                    </button>
                </div>
            </div>
        </div>

    </form>

</div>
</div>
</div>


<?php 
// FOOTER
$system_footer .= "";
include('../../_layout/rdp.php');
include('../../_layout/footer.php');
?>

<script>
$(document).ready( function() {
  $("#the_form").validate({
    rules: {
      nome: { required: true },
      whatsapp: { required: true }
    },
    messages: {
      nome: { required: "Esse campo é obrigatório" },
      whatsapp: { required: "Esse campo é obrigatório" }
    }
  });
});



</script>