<?php
include('../../../_core/_includes/config.php');
restrict_estabelecimento();
restrict_expirado();
$subtitle = "Deletar Categorias Selecionadas";
?>

<!-- Aditional Header's -->

<?php

	// Recebe os IDs das categorias a serem deletadas, passados como uma string separada por vírgulas
	$ids = isset($_GET['ids']) ? $_GET['ids'] : '';
	$eid = $_SESSION['estabelecimento']['id'];

	if ($ids) {
		// Converte a string de IDs em um array
		$ids_array = explode(',', $ids);

		// Verifica se todas as categorias pertencem ao mesmo estabelecimento
		$id_placeholder = implode(',', array_fill(0, count($ids_array), '?'));
		$query = "SELECT * FROM categorias WHERE id IN ($id_placeholder) AND rel_estabelecimentos_id = ?";
		$stmt = mysqli_prepare($db_con, $query);
		$params = array_merge($ids_array, [$eid]);
		mysqli_stmt_bind_param($stmt, str_repeat('i', count($params)), ...$params);
		mysqli_stmt_execute($stmt);
		$result = mysqli_stmt_get_result($stmt);

		// Verifica se todas as categorias pertencem ao mesmo estabelecimento
		$cando = (mysqli_num_rows($result) === count($ids_array));

		if ($cando) {
			// Deleta as categorias
			foreach ($ids_array as $id) {
				if (!delete_categoria($id)) {
					header("Location: ../index.php?msg=erro");
					exit();
				}
			}

			// Redireciona para a página com sucesso
			header("Location: ../index.php?msg=sucesso");
		} else {
			// Se algum ID não pertence ao estabelecimento, redireciona para erro
			header("Location: ../index.php?msg=erro");
		}
	} else {
		// Se não houver IDs válidos, redireciona para erro
		header("Location: ../index.php?msg=erro");
	}

?>
