<?php
// CORE
include('../_core/_includes/config.php');
// SEO
$seo_subtitle = "Login";
$seo_description = "";
$seo_keywords = "";
// HEADER
$system_header = "";
// CHECK LOGGED
if( $_SESSION['user']['logged'] == "1" ) {

	if( $_SESSION['user']['level'] == "1" ) {
		header("Location: ../administracao/inicio");
	}

	if( $_SESSION['user']['level'] == "2" ) {
		header("Location: ../painel/inicio");
	}
	
	if( $_SESSION['user']['level'] == "3" ) {
		header("Location: ../afiliado/inicio");
	}

}
?>




<!DOCTYPE html>

<html><head>
    
    <script>
    // Bloqueia botão direito do mouse
    document.addEventListener('contextmenu', function(e) {
        e.preventDefault();
    }, false);

    // Bloqueia atalhos do teclado
    document.addEventListener('keydown', function(e) {
        // Bloqueia F12
        if (e.keyCode == 123) {
            e.preventDefault();
        }
        
        // Bloqueia Ctrl+Shift+I
        if (e.ctrlKey && e.shiftKey && e.keyCode == 73) {
            e.preventDefault();
        }
        
        // Bloqueia Ctrl+Shift+J
        if (e.ctrlKey && e.shiftKey && e.keyCode == 74) {
            e.preventDefault();
        }
        
        // Bloqueia Ctrl+U (visualizar fonte)
        if (e.ctrlKey && e.keyCode == 85) {
            e.preventDefault();
        }

        // Bloqueia Ctrl+S
        if (e.keyCode == 83 && (navigator.platform.match("Mac") ? e.metaKey : e.ctrlKey)) {
            e.preventDefault();
        }
    }, false);
</script>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>
<?php $nome_loja; ?> - Login</title>
<meta name="description" content="">
<meta name="keywords" content="">
<meta property="og:title" content="Login - <?php $nome_loja; ?>">
<meta property="og:description" content="">
<meta property="og:image" content="<?php just_url(); ?>/_core/_cdn/img/favicon.png">
<link rel="shortcut icon" href="<?php just_url(); ?>/_core/_cdn/img/favicon.png">
<link rel="manifest" href="<?php just_url(); ?>/login/manifest.json">
<link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/bootstrap/css/bootstrap.min.css">
<link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/panel/css/class.css">
<link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/panel/css/forms.css">
<link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/panel/css/typography.css">
<link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/panel/css/template.css">
<link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/panel/css/theme.css">
<link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/panel/css/default.css">
<link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/lineicons/css/LineIcons.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&amp;display=swap" rel="stylesheet">
<!-- <link rel="stylesheet" href="<?php just_url(); ?>/_core/_cdn/fonts/style.min.css"> -->
</head>
<body>
	    
	    <script>
// This is the service worker with the Cache-first network
// Add this below content to your HTML page, or add the js file to your page at the very top to register service worker
// Check compatibility for the browser we're running this in
if ("serviceWorker" in navigator) {
 if (navigator.serviceWorker.controller) {
 console.log("[PWA Builder] active service worker found, no need to register");
 } else {
 // Register the service worker
 navigator.serviceWorker
 .register("<?php just_url(); ?>/login/pwabuilder-sw.js", {
 scope: "./"
 })
 .then(function (reg) {
 console.log("[PWA Builder] Service worker has been registered for scope: " + reg.scope);
 });
 }
}
</script>

		<?php

		$redirect = mysqli_real_escape_string( $db_con, $_GET['redirect'] );
		// if( !$redirect ) {
		// 	$redirect = $_SERVER['HTTP_REFERER'];
		// }
		$email = strtolower( mysqli_real_escape_string( $db_con, $_POST['email'] ) );
		$pass = mysqli_real_escape_string( $db_con, $_POST['pass'] );
		$keepalive = mysqli_real_escape_string( $db_con, $_POST['keepalive'] );
		if( !$keepalive ) {
			$keepalive = 0;
		}
		$method = "login";

		if( notnull($email) && notnull($pass) ) {

			if( make_login( $email,$pass,$method,$keepalive ) ) {

				if( $redirect ) {
					header("Location: ".$redirect);
				} else {
					header("Location: index.php");
				}

			} else {

				header("Location: index.php?msg=erro&email=".$email."&redirect=".$redirect);

			}

		}


		?>
		
		
		
		
		
<main class="bg-gray fullfit d-flex align-items-center min-vh-100 py-3 py-md-0" style="min-height: 1390px;">
  <div class="container">
    <div class="card login-card">
      <div class="row">
        <div class="col-md-5 hidden-xs hidden-sm "> <img src="<?php just_url(); ?>/login/img/login.jpg" alt="login" class="login-card-img"> </div>
        <div class="col-md-7">
          <div class="login">
            <form method="POST" action="<?php just_url(); ?>/login/index.php?redirect=<?php echo $redirect; ?>">
              <div class="row"> 
                
                <!-- Login Box -->
                <div class="login-box box-white">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="brand brand-login text-center"> <img src="<?php just_url(); ?>/_core/_cdn/img/logo.png" width="160" style="height:80px !important;" class="img-responsive m-2"> </div>
                    </div>
                  </div>
                  <?php if( $_GET['msg'] == "erro" ) { ?>

												<div class="row">

													<div class="col-md-12">

														<div class="msg msg-error bg-gray mt-10">
															<i class="lni lni-close"></i>
															<span>Dados incorretos, tente novamente!</span>
														</div>

													</div>

												</div>

												<?php } ?>

												<?php if( $_GET['msg'] == "alterada" ) { ?>

												<div class="row">

													<div class="col-md-12">

														<div class="msg msg-done bg-gray mt-10">
															<i class="lni lni-checkmark"></i>
															<span>Senha alterada com sucesso, faça login para continuar!</span>
														</div>

													</div>

												</div>

												<?php } ?>
												
												
                                                      <div class="row">
                    <div class="col-md-12">
                      <div class="form-field form-field-icon form-field-text"> <i class="form-icon lni lni-user"></i>
                        <input type="text" name="email" placeholder="E-mail" value="<?php echo htmlclean( $_GET['email'] ); ?>">
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-field form-field-icon form-field-password"> <i class="form-icon lni lni-lock"></i>
                        <input type="password" name="pass" placeholder="Senha">
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-field form-field-icon form-field-checkbox">
                        <input type="checkbox" name="keepalive" value="1" checked="">
                        <span>Mantenha-me conectado</span> </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-field form-field-icon form-field-submit">
                        <button> <span>Acessar painel</span> <i class="lni lni-chevron-right"></i> </button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      <div class="forgetpass"> <a href="<?php just_url(); ?>/esqueci"><i class="lni lni-question-circle"></i> Esqueceu a senha?</a> <a href="<?php just_url(); ?>/comece"><i class="lni lni-licencse"></i> Cadastrar-se</a> <a href="<?php just_url(); ?>" class="bt-voltar"><i class="icone icone-sacola"></i> Voltar</a> 
                        
                        <!-- <a href="<?php //just_url(); ?>/comece"><i class="lni lni-rocket"></i> Quero vender</a> --> 
                        
                      </div>
                    </div>
                  </div>
                </div>
                <!-- / Login Box --> 
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>

	
	</body>

</html>

<script src="<?php just_url(); ?>/_core/_cdn/jquery/js/jquery.min.js"></script>
<script src="<?php just_url(); ?>/_core/_cdn/panel/js/template.js"></script>

