<?php
// CORE
include('../../_core/_includes/config.php');
// RESTRICT
restrict('1');
// SEO
$seo_subtitle = "Ínicio";
$seo_description = "";
$seo_keywords = "";
// HEADER
$system_header .= "";
include('../_layout/head.php');
include('../_layout/top.php');
include('../_layout/sidebars.php');
include('../_layout/modal.php');

global $db_con;

//pega estado
$queryestados = mysqli_query($db_con, "SELECT * FROM estados WHERE id = $estop");
$dataest = mysqli_fetch_array($queryestados);

//pega cidade
$querycidades = mysqli_query($db_con, "SELECT * FROM cidades WHERE id = $cidop");
$datacid = mysqli_fetch_array($querycidades);


// Consulta SQL para selecionar o link do vídeo
$query_video = mysqli_query($db_con, "SELECT link FROM link WHERE nome='video'");
$datalink_video = mysqli_fetch_array($query_video);
$link_video = $datalink_video['link'];

// Consulta SQL para selecionar o link do wppmkt
$query_wppmkt = mysqli_query($db_con, "SELECT link FROM link WHERE nome='wppmkt'");
$datalink_wppmkt = mysqli_fetch_array($query_wppmkt);
$link_wppmkt = $datalink_wppmkt['link'];

// Consulta SQL para selecionar o link do video_landing
$query_video_landing = mysqli_query($db_con, "SELECT link FROM link WHERE nome='video_landing'");
$datalink_video_landing = mysqli_fetch_array($query_video_landing);
$link_video_landing = $datalink_video_landing['link'];

// Consulta SQL para selecionar o link do artes
$query_artes = mysqli_query($db_con, "SELECT link FROM link WHERE nome='artes'");
$datalink_artes = mysqli_fetch_array($query_artes);
$link_artes = $datalink_artes['link'];



function atualizar_link($db_con, $tipo_link)
{
	$link = 'link_' . $tipo_link;
	$link = isset($_GET[$link]) ? mysqli_real_escape_string($db_con, $_GET[$link]) : null;
	$querylink = mysqli_query($db_con, "SELECT link FROM link WHERE nome='$tipo_link'");
	$datalink = mysqli_fetch_array($querylink);

	if ($datalink) {
		// Se $datalink não estiver vazio, atualize o registro
		if (mysqli_query($db_con, "UPDATE link SET link = '$link' WHERE nome = '$tipo_link'")) {
			header("Location: index.php?msg=sucesso");
		}
	} else {
		// Se $datalink estiver vazio, insira um novo registro
		if (mysqli_query($db_con, "INSERT INTO link (nome, link) VALUES ('$tipo_link', '$link')")) {
			header("Location: index.php?msg=sucesso");
		}
	}
}

if (isset($_GET['set_video'])) {
	atualizar_link($db_con, 'video');
}

if (isset($_GET['set_wppmkt'])) {
	atualizar_link($db_con, 'wppmkt');
}

if (isset($_GET['set_video_landing'])) {
	atualizar_link($db_con, 'video_landing');
}

if (isset($_GET['set_artes'])) {
	atualizar_link($db_con, 'artes');
}

// Mensagens de alerta
if ($_GET['msg'] == "erro") {
	modal_alerta("Erro, tente novamente mais tarde!", "erro");
}

if ($_GET['msg'] == "sucesso") {
	modal_alerta("Editado com sucesso!", "sucesso");
}

// Função para criar um modal
function criar_modal($id_modal, $titulo, $link)
{
	global $datalink;
	echo '
    <div id="modal' . $id_modal . '" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h4 class="modal-title">' . $titulo . '</h4>
                </div>
                <div class="modal-body">
                    <textarea id="link_' . $id_modal . '" rows="1" cols="50">' . $link . '</textarea>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-default" style="background-color: black; color: white;" data-dismiss="modal">Fechar</a>
                    <a href="#" id="botao_salvar_' . $id_modal . '" class="btn navigator" style="padding: 6px 12px !important; color: white;"> Salvar <i class="lni lni-save"></i></a>
                </div>
            </div>
        </div>
    </div>
    ';
}

// Criação dos modais
criar_modal('video', 'Link para as Vídeo Aulas', $link_video);
criar_modal('wppmkt', 'Link para as Whatsapp Marketing', $link_wppmkt);
criar_modal('video_landing', 'Link para o Vídeo da Página de Vendas', $link_video_landing);
criar_modal('artes', 'Link para as Artes Prontas', $link_artes);




?>

<script>
	// Função para adicionar evento de clique ao botão salvar
	function adicionar_evento(tipo_link) {
		document.getElementById('botao_salvar_' + tipo_link).addEventListener('click', function(e) {
			e.preventDefault();
			var link = document.getElementById('link_' + tipo_link).value;
			var url = "<?php echo admin_url(); ?>/inicio/?link_" + tipo_link + "=" + encodeURIComponent(link) + "&set_" + tipo_link + "=true";
			console.log(url);
			window.location.href = url;
		});
	}

	// Adicionando eventos aos botões salvar
	adicionar_evento('video');
	adicionar_evento('wppmkt');
	adicionar_evento('video_landing');
	adicionar_evento('artes');
</script>

<div class="middle minfit bg-gray">

	<div class="container">

		<div class="row">

			<div class="col-md-12">

				<span class="welcome-message">Olá seja bem vindo, utilize os menus abaixo para gerenciar o seu estabelecimento:</span>
				<br>
			</div>

			<?
			//number_format($define_sqlmensal['soma1'], 2, ',', '.')

			$sqlmensal = mysqli_query($db_con, "SELECT SUM(valor_total) AS soma1 FROM assinaturas WHERE 1=1 AND status = '1' AND (created > '2021-12-01' AND duracao_dias > '29' AND duracao_dias < '32' AND used = '1' ) ");
			$define_sqlmensal = mysqli_fetch_array($sqlmensal);

			//assinaturas ativas mensal
			$sql1x = mysqli_query($db_con, "SELECT * FROM assinaturas WHERE 1=1 AND status = '1' AND (created > '2021-12-01' AND duracao_dias > '29' AND duracao_dias < '32' AND used = '1')");
			$total_results1 = mysqli_num_rows($sql1x);


			$sqltrimestral = mysqli_query($db_con, "SELECT SUM(valor_total) AS soma3 FROM assinaturas WHERE 1=1 AND status = '1' AND (created > '2021-12-01' AND duracao_dias = '90' AND used = '1' ) ");
			$define_sqltrimestral = mysqli_fetch_array($sqltrimestral);

			//assinaturas ativas trimestral
			$sql2x = mysqli_query($db_con, "SELECT * FROM assinaturas WHERE 1=1 AND status = '1' AND (created > '2021-12-01' AND duracao_dias = '90' AND used = '1')");
			$total_results2 = mysqli_num_rows($sql2x);

			$sqlsemestral = mysqli_query($db_con, "SELECT SUM(valor_total) AS soma4 FROM assinaturas WHERE 1=1 AND status = '1' AND (created > '2021-12-01' AND duracao_dias = '180' AND used = '1' ) ");
			$define_sqlsemestral = mysqli_fetch_array($sqlsemestral);

			//assinaturas ativas semestral
			$sqlsx = mysqli_query($db_con, "SELECT * FROM assinaturas WHERE 1=1 AND status = '1' AND (created > '2021-12-01' AND duracao_dias = '180' AND used = '1')");
			$total_resultss = mysqli_num_rows($sqlsx);


			$sqlanual = mysqli_query($db_con, "SELECT SUM(valor_total) AS soma2 FROM assinaturas WHERE 1=1 AND status = '1' AND (created > '2021-12-01' AND duracao_dias = '365' AND used = '1' ) ");
			$define_sqlanual = mysqli_fetch_array($sqlanual);

			//assinaturas ativas anual
			$sql3x = mysqli_query($db_con, "SELECT * FROM assinaturas WHERE 1=1 AND status = '1' AND (created > '2021-12-01' AND duracao_dias = '365' AND used = '1')");
			$total_results3 = mysqli_num_rows($sql3x);

			//assinaturas expiradas
			$sql4x = mysqli_query($db_con, "SELECT * FROM estabelecimentos WHERE 1=1 AND expiracao = '0'");
			$total_results4 = mysqli_num_rows($sql4x);

			//total de catálogos
			$sql5x = mysqli_query($db_con, "SELECT * FROM estabelecimentos WHERE 1=1");
			$total_results5 = mysqli_num_rows($sql5x);

			$mensal = $define_sqlmensal['soma1'];
			$trimestral = $define_sqltrimestral['soma3'] / 3;
			$semestral = $define_sqlsemestral['soma4'] / 6;
			$anual = $define_sqlanual['soma2'] / 12;

			$lucromensal = $mensal + $trimestral + $semestral + $anual;
			$totalcatalogosativos = $total_results1 + $total_results2 + $total_results3 + $total_resultss;


			?>

			<center>
				<div class="row">
					<div class="col-md-3 half-left col-sm-6 col-xs-6">
						<center>
							<h3>
								<?
								setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
								echo "Ganho Mensal";
								?>
							</h3>
							<h4>R$: <?php echo number_format($lucromensal, 2, ',', '.'); ?></h4>
						</center>
					</div>
					<div class="col-md-2 half-left col-sm-6 col-xs-6">
						<div id="task-complete"></div>
						Lojas com <br>
						Assinaturas ativas
						<br>
						R$: <?php echo number_format($lucromensal, 2, ',', '.'); ?>
					</div>
					<div class="col-md-2 half-left col-sm-6 col-xs-6">
						<div id="task-complete2"></div>
						Lojas<br>
						em período de teste
					</div>
					<div class="col-md-2 half-left col-sm-6 col-xs-6">
						<div id="task-complete3"></div>
						Lojas<br>
						Desativadas
					</div>
					<div class="col-md-2 half-left col-sm-6 col-xs-6">
						<div id="task-complete4"></div>
						Total de Lojas
					</div>

				</div>
			</center>
			<script>
				! function(a, b) {
					"object" == typeof exports ? module.exports = b() : "function" == typeof define && define.amd ? define([], b) : a.Circles = b()
				}(this, function() {
					"use strict";
					var a = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function(a) {
							setTimeout(a, 1e3 / 60)
						},
						b = function(a) {
							var b = a.id;
							if (this._el = document.getElementById(b), null !== this._el) {
								this._radius = a.radius || 10, this._duration = void 0 === a.duration ? 500 : a.duration, this._value = 1e-7, this._maxValue = a.maxValue || 100, this._text = void 0 === a.text ? function(a) {
									return this.htmlifyNumber(a)
								} : a.text, this._strokeWidth = a.width || 10, this._colors = a.colors || ["#EEE", "#F00"], this._svg = null, this._movingPath = null, this._wrapContainer = null, this._textContainer = null, this._wrpClass = a.wrpClass || "circles-wrp", this._textClass = a.textClass || "circles-text", this._valClass = a.valueStrokeClass || "circles-valueStroke", this._maxValClass = a.maxValueStrokeClass || "circles-maxValueStroke", this._styleWrapper = !1 !== a.styleWrapper, this._styleText = !1 !== a.styleText;
								var c = Math.PI / 180 * 270;
								this._start = -Math.PI / 180 * 90, this._startPrecise = this._precise(this._start), this._circ = c - this._start, this._generate().update(a.value || 0)
							}
						};
					return b.prototype = {
						VERSION: "0.0.6",
						_generate: function() {
							return this._svgSize = 2 * this._radius, this._radiusAdjusted = this._radius - this._strokeWidth / 2, this._generateSvg()._generateText()._generateWrapper(), this._el.innerHTML = "", this._el.appendChild(this._wrapContainer), this
						},
						_setPercentage: function(a) {
							this._movingPath.setAttribute("d", this._calculatePath(a, !0)), this._textContainer.innerHTML = this._getText(this.getValueFromPercent(a))
						},
						_generateWrapper: function() {
							return this._wrapContainer = document.createElement("div"), this._wrapContainer.className = this._wrpClass, this._styleWrapper && (this._wrapContainer.style.position = "relative", this._wrapContainer.style.display = "inline-block"), this._wrapContainer.appendChild(this._svg), this._wrapContainer.appendChild(this._textContainer), this
						},
						_generateText: function() {
							if (this._textContainer = document.createElement("div"), this._textContainer.className = this._textClass, this._styleText) {
								var a = {
									position: "absolute",
									top: 0,
									left: 0,
									textAlign: "center",
									width: "100%",
									fontSize: .7 * this._radius + "px",
									height: this._svgSize + "px",
									lineHeight: this._svgSize + "px"
								};
								for (var b in a) this._textContainer.style[b] = a[b]
							}
							return this._textContainer.innerHTML = this._getText(0), this
						},
						_getText: function(a) {
							return this._text ? (void 0 === a && (a = this._value), a = parseFloat(a.toFixed(2)), "function" == typeof this._text ? this._text.call(this, a) : this._text) : ""
						},
						_generateSvg: function() {
							return this._svg = document.createElementNS("http://www.w3.org/2000/svg", "svg"), this._svg.setAttribute("xmlns", "http://www.w3.org/2000/svg"), this._svg.setAttribute("width", this._svgSize), this._svg.setAttribute("height", this._svgSize), this._generatePath(100, !1, this._colors[0], this._maxValClass)._generatePath(1, !0, this._colors[1], this._valClass), this._movingPath = this._svg.getElementsByTagName("path")[1], this
						},
						_generatePath: function(a, b, c, d) {
							var e = document.createElementNS("http://www.w3.org/2000/svg", "path");
							return e.setAttribute("fill", "transparent"), e.setAttribute("stroke", c), e.setAttribute("stroke-width", this._strokeWidth), e.setAttribute("d", this._calculatePath(a, b)), e.setAttribute("class", d), this._svg.appendChild(e), this
						},
						_calculatePath: function(a, b) {
							var c = this._start + a / 100 * this._circ,
								d = this._precise(c);
							return this._arc(d, b)
						},
						_arc: function(a, b) {
							var c = a - .001,
								d = a - this._startPrecise < Math.PI ? 0 : 1;
							return ["M", this._radius + this._radiusAdjusted * Math.cos(this._startPrecise), this._radius + this._radiusAdjusted * Math.sin(this._startPrecise), "A", this._radiusAdjusted, this._radiusAdjusted, 0, d, 1, this._radius + this._radiusAdjusted * Math.cos(c), this._radius + this._radiusAdjusted * Math.sin(c), b ? "" : "Z"].join(" ")
						},
						_precise: function(a) {
							return Math.round(1e3 * a) / 1e3
						},
						htmlifyNumber: function(a, b, c) {
							b = b || "circles-integer", c = c || "circles-decimals";
							var d = (a + "").split("."),
								e = '<span class="' + b + '">' + d[0] + "</span>";
							return d.length > 1 && (e += '.<span class="' + c + '">' + d[1].substring(0, 2) + "</span>"), e
						},
						updateRadius: function(a) {
							return this._radius = a, this._generate().update(!0)
						},
						updateWidth: function(a) {
							return this._strokeWidth = a, this._generate().update(!0)
						},
						updateColors: function(a) {
							this._colors = a;
							var b = this._svg.getElementsByTagName("path");
							return b[0].setAttribute("stroke", a[0]), b[1].setAttribute("stroke", a[1]), this
						},
						getPercent: function() {
							return 100 * this._value / this._maxValue
						},
						getValueFromPercent: function(a) {
							return this._maxValue * a / 100
						},
						getValue: function() {
							return this._value
						},
						getMaxValue: function() {
							return this._maxValue
						},
						update: function(b, c) {
							if (!0 === b) return this._setPercentage(this.getPercent()), this;
							if (this._value == b || isNaN(b)) return this;
							void 0 === c && (c = this._duration);
							var d, e, f, g, h = this,
								i = h.getPercent(),
								j = 1;
							return this._value = Math.min(this._maxValue, Math.max(0, b)), c ? (d = h.getPercent(), e = d > i, j += d % 1, f = Math.floor(Math.abs(d - i) / j), g = c / f, function b(c) {
								if (e ? i += j : i -= j, e && i >= d || !e && i <= d) return void a(function() {
									h._setPercentage(d)
								});
								a(function() {
									h._setPercentage(i)
								});
								var f = Date.now(),
									k = f - c;
								k >= g ? b(f) : setTimeout(function() {
									b(Date.now())
								}, g - k)
							}(Date.now()), this) : (this._setPercentage(this.getPercent()), this)
						}
					}, b.create = function(a) {
						return new b(a)
					}, b
				});
			</script>
			<script>
				Circles.create({
					id: 'task-complete',
					radius: 40,
					value: <?php print $totalcatalogosativos; ?>,
					maxValue: 100,
					width: 7,
					text: function(value) {
						return value;
					},
					colors: ['#eee', '#177dff'],
					duration: 400,
					wrpClass: 'circles-wrp',
					textClass: 'circles-text',
					styleWrapper: true,
					styleText: true
				})
			</script>
			<script>
				Circles.create({
					id: 'task-complete2',
					radius: 40,
					value: <?php print $total_results2; ?>,
					maxValue: 100,
					width: 7,
					text: function(value) {
						return value;
					},
					colors: ['#eee', '#177dff'],
					duration: 400,
					wrpClass: 'circles-wrp',
					textClass: 'circles-text',
					styleWrapper: true,
					styleText: true
				})
			</script>
			<script>
				Circles.create({
					id: 'task-complete3',
					radius: 40,
					value: <?php print $total_results4; ?>,
					maxValue: 100,
					width: 7,
					text: function(value) {
						return value;
					},
					colors: ['#eee', '#177dff'],
					duration: 400,
					wrpClass: 'circles-wrp',
					textClass: 'circles-text',
					styleWrapper: true,
					styleText: true
				})
			</script>
			<script>
				Circles.create({
					id: 'task-complete4',
					radius: 40,
					value: <?php print $total_results5; ?>,
					maxValue: 100,
					width: 7,
					text: function(value) {
						return value;
					},
					colors: ['#eee', '#177dff'],
					duration: 400,
					wrpClass: 'circles-wrp',
					textClass: 'circles-text',
					styleWrapper: true,
					styleText: true
				})
			</script>

			<br>
			<br>
		</div>


		<span class="welcome-message">
			<h3>Administrativo <?php print $datacid['nome']; ?> / <?php print $dataest['uf']; ?></h3>
			<a href="https://wa.me/<? echo $whatsapp ?>" target="_blank">
				<button type="button" class="btn btn-success">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-whatsapp" viewBox="0 0 16 16">
						<path d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z" />
					</svg>
					Chamar Suporte
				</button></a>

		</span>

	</div>

</div>


<div class="lista-menus">

	<div class="row">
		<div class="col-md-12">
			<div class="lista-menus-menu">
				<a class="bt" href="<?php admin_url(); ?>/configuracoes">
					<i class="lni lni-cog"></i>
					<span>CONFIGURAÇÕES DO SISTEMA</span>
					<strong><i class="lni lni-chevron-right text-center"></i></strong>
					<div class="clear"></div>
				</a>
			</div>
		</div>

		<?php if ($oper == 1) { ?>
			<div class="col-md-4">
				<div class="lista-menus-menu">
					<a class="bt" href="<?php admin_url(); ?>/usuarios">
						<i class="lni lni-radio-button"></i>
						<span>Usuários</span>
						<strong><i class="lni lni-chevron-right text-center"></i></strong>
						<div class="clear"></div>
					</a>
				</div>
			</div>


			<div class="col-md-4">
				<div class="lista-menus-menu">
					<a class="bt" href="<?php admin_url(); ?>/subdominios">
						<i class="lni lni-domain"></i>
						<span>Subdominios</span>
						<strong><i class="lni lni-chevron-right text-center"></i></strong>
						<div class="clear"></div>
					</a>
				</div>
			</div>
		<?php } ?>

		<?php if ($oper == 2) { ?>
			<div class="col-md-4">
				<div class="lista-menus-menu">
					<a class="bt" href="<?php admin_url(); ?>/segmentos">
						<i class="lni lni-domain"></i>
						<span>Segmentos</span>
						<strong><i class="lni lni-chevron-right text-center"></i></strong>
						<div class="clear"></div>
					</a>
				</div>
			</div>
		<?php } ?>

		<div class="col-md-4">
			<div class="lista-menus-menu">
				<a class="bt" href="<?php admin_url(); ?>/estabelecimentos">
					<i class="lni lni-home"></i>
					<span>Estabelecimentos</span>
					<strong><i class="lni lni-chevron-right text-center"></i></strong>
					<div class="clear"></div>
				</a>
			</div>
		</div>
		<?php if ($oper == 1) { ?>
			<div class="col-md-4">
				<div class="lista-menus-menu">
					<a class="bt" href="<?php admin_url(); ?>/assinaturas">
						<i class="lni lni-star"></i>
						<span>Assinaturas</span>
						<strong><i class="lni lni-chevron-right text-center"></i></strong>
						<div class="clear"></div>
					</a>
				</div>
			</div>
		<?php } ?>
		<div class="col-md-4">
			<div class="lista-menus-menu">
				<a class="bt" href="<?php admin_url(); ?>/vouchers">
					<i class="lni lni-ticket-alt"></i>
					<span>Vouchers</span>
					<strong><i class="lni lni-chevron-right text-center"></i></strong>
					<div class="clear"></div>
				</a>
			</div>
		</div>
		<?php if ($oper == 1) { ?>
			<div class="col-md-4">
				<div class="lista-menus-menu">
					<a class="bt" href="<?php admin_url(); ?>/planos">
						<i class="lni lni-list"></i>
						<span>Planos</span>
						<strong><i class="lni lni-chevron-right text-center"></i></strong>
						<div class="clear"></div>
					</a>
				</div>
			</div>

		<?php } ?>
		<!-- VIDEO_AULAS BTN -->
		<div class="col-md-4">
			<div class="lista-menus-menu">
				<a class="bt" href="#" data-toggle="modal" data-target="#modalvideo">
					<i class="lni lni-video"></i>
					<span>Vídeo Aulas</span>
					<strong><i class="lni lni-chevron-right text-center"></i></strong>
					<div class="clear"></div>
				</a>

			</div>
		</div>

		<div class="col-md-4">
			<div class="lista-menus-menu">
				<a class="bt" id="bttemas" href="#" data-toggle="modal" data-target="#mTemas">
					<i class="lni lni-brush"></i>
					<span>Tema Landspage</span>
					<strong><i class="lni lni-chevron-right text-center"></i></strong>
					<div class="clear"></div>
				</a>

			</div>
		</div>

		<!-- VIDEO_AULAS BTN -->

		<!-- WPPMKT BTN -->
		<div class="col-md-4">
			<div class="lista-menus-menu">
				<a class="bt" href="#" data-toggle="modal" data-target="#modalwppmkt">
					<i class="lni lni-whatsapp"></i>
					<span>Whatsapp Marketing</span>
					<strong><i class="lni lni-chevron-right text-center"></i></strong>
					<div class="clear"></div>
				</a>

			</div>
		</div>
		<!-- WPPMKT BTN-->

		<div class="col-md-4">
			<div class="lista-menus-menu">
				<a class="bt" href="#" data-toggle="modal" data-target="#modalvideo_landing">
					<i class="lni lni-whatsapp"></i>
					<span>Vídeo da página conheca</span>
					<strong><i class="lni lni-chevron-right text-center"></i></strong>
					<div class="clear"></div>
				</a>

			</div>
		</div>


		<!--<div class="col-md-4">-->
		<!--		<div class="lista-menus-menu">-->
		<!--			<a class="bt" href="#" data-toggle="modal" data-target="#modalartes">-->
		<!--                         <i class="lni lni-pallet"></i>-->
		<!--                         <span>Link para as Artes Prontas</span>-->
		<!--                         <strong><i class="lni lni-chevron-right text-center"></i></strong>-->
		<!--                         <div class="clear"></div>-->
		<!--                     </a>-->

		<!--		</div>-->
		<!--</div>-->

	</div>

</div>

</div>

<div style="padding-right: 15vw; padding-left: 15vw;">
	<h3>Notificação</h3>
	<label>Titulo</label>
	<input id="msg_title" type="text" />
	<label>Descrição</label>
	<textarea id="msg_description"></textarea>
	<label>Link</label>
	<input id="msg_link" type="text" />


	<p>
	<p>

	<div class="lista-menus">

		<div class="row">

			<div class="col-md-4">

				<div class="lista-menus-menu">

					<a class="bt" onclick="enviaNotificacao()">

						<i class="lni lni-popup"></i>

						<span>Enviar Notificação</span>

						<strong><i class="lni lni-chevron-right text-center"></i></strong>

						<div class="clear"></div>

					</a>

				</div>

			</div>

		</div>

	</div>

</div>




</div>

<?php
// FOOTER
$system_footer .= "";
include('../_layout/rdp.php');
include('../_layout/footer.php');
?>

<div id="mTemas" class="modal fade" role="dialog">
	<div class="modal-dialog modal-lg modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">×</button>
				<h4 class="modal-title">TEMAS:</h4>
			</div>
			<div class="modal-body">

				<div class="row row-cols-1 row-cols-md-2">
					<div class="col mb-4">
						<div class="card">
							<img src="templates/default.jpg" class="card-img-top" alt="...">
							<div class="card-body">
								<h5 class="card-title">Default</h5>
								<p class="card-text"><button class="btn btn-success w-100 m-2" type="button" data-value="default" onclick="aplicarTema($(this).attr('data-value'))">Aplicar</button></p>
							</div>
						</div>
					</div>
					<div class="col mb-4">
						<div class="card">
							<img src="templates/blue.jpg" class="card-img-top" alt="...">
							<div class="card-body">
								<h5 class="card-title">Azul</h5>
								<p class="card-text"><button class="btn btn-success w-100 m-2" type="button" data-value="blue" onclick="aplicarTema($(this).attr('data-value'))">Aplicar</button></p>
							</div>
						</div>
					</div>
					<div class="col mb-4">
						<div class="card">
							<img src="templates/orange.jpg" class="card-img-top" alt="...">
							<div class="card-body">
								<h5 class="card-title">Laranja</h5>
								<p class="card-text"><button class="btn btn-success w-100 m-2" type="button" data-value="orange" onclick="aplicarTema($(this).attr('data-value'))">Aplicar</button></p>
							</div>
					</div>
					<div class="col mb-4">
						<div class="card">
							<img src="templates/red.jpg" class="card-img-top" alt="...">
							<div class="card-body">
								<h5 class="card-title">Vermelho</h5>
								<p class="card-text"><button class="btn btn-success w-100 m-2" type="button" data-value="red" onclick="aplicarTema($(this).attr('data-value'))">Aplicar</button></p>
							</div>
						</div>
					</div>
					<div class="col mb-4">
						<div class="card">
							<img src="templates/green.jpg" class="card-img-top" alt="...">
							<div class="card-body">
								<h5 class="card-title">Verde</h5>
								<p class="card-text"><button class="btn btn-success w-100 m-2" type="button" data-value="green" onclick="aplicarTema($(this).attr('data-value'))">Aplicar</button></p>
							</div>
						</div>
					</div>
				</div>


			</div>
			<div class="modal-footer">
				<a href="#" class="btn btn-default" style="background-color: black; color: white;" data-dismiss="modal">Fechar</a>
				<a href="#" id="botao_salvar_' . $id_modal . '" class="btn navigator" style="padding: 6px 12px !important; color: white;"> Salvar <i class="lni lni-save"></i></a>
			</div>
		</div>
	</div>
</div>



<script>
	const enviaNotificacao = () => {
		let title = document.querySelector("#msg_title").value;
		let description = document.querySelector("#msg_description").value;
		let link = document.querySelector("#msg_link").value;

		if (!link || link == "") {
			link = "%23";
		}

		//  console.log(link);
		if (title && description) {
			window.location.href = `/administracao/Notifications?title=${title}&description=${description}&link=${link}`;
		} else {
			alert("Você precisa preencher todos os campos de notificação primeiro!");
		}
	};

	function aplicarTema(tema){

		$.ajax({
        url: 'aplicar_tema.php',
        type: 'POST',
        data: { tema: tema },
        success: function(response) {
            alert(response);
            // Opcional: recarregar a página para aplicar o novo CSS
            // location.reload();
        },
        error: function() {
            alert('Erro ao aplicar tema!');
        }
    });
	}
</script>