<?php

function new_fretec($estabelecimento, $nome, $valor, $outros) {
    global $db_con;

    $stmt = $db_con->prepare("INSERT INTO frete (rel_estabelecimentos_id, nome, valor, outros) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $estabelecimento, $nome, $valor, $outros);

    return $stmt->execute();
}

function edit_fretec($id, $nome, $valor) {
    global $db_con;

    $stmt = $db_con->prepare("UPDATE frete SET nome = ?, valor = ? WHERE id = ?");
    $stmt->bind_param("ssi", $nome, $valor, $id);

    return $stmt->execute();
}

function delete_fretec($id) {
    global $db_con;

    $stmt = $db_con->prepare("DELETE FROM frete WHERE id = ?");
    $stmt->bind_param("i", $id);

    return $stmt->execute();
}

function new_frete($estabelecimento, $nome, $valor) {
    global $db_con;

    $stmt = $db_con->prepare("INSERT INTO frete (rel_estabelecimentos_id, nome, valor) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $estabelecimento, $nome, $valor);

    return $stmt->execute();
}

function edit_frete($id, $nome, $valor) {
    global $db_con;

    $stmt = $db_con->prepare("UPDATE frete SET nome = ?, valor = ? WHERE id = ?");
    $stmt->bind_param("ssi", $nome, $valor, $id);

    return $stmt->execute();
}

function delete_frete($id) {
    global $db_con;

    $stmt = $db_con->prepare("DELETE FROM frete WHERE id = ?");
    $stmt->bind_param("i", $id);

    return $stmt->execute();
}


function new_cupom($estabelecimento, $nome, $descricao, $codigo, $tipo, $desconto_porcentagem, $desconto_fixo, $valor_maximo, $quantidade, $validade) {
    global $db_con;

    $stmt = $db_con->prepare("INSERT INTO cupons (rel_estabelecimentos_id, nome, descricao, codigo, tipo, desconto_porcentagem, desconto_fixo, valor_maximo, quantidade, validade) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssddss", $estabelecimento, $nome, $descricao, $codigo, $tipo, $desconto_porcentagem, $desconto_fixo, $valor_maximo, $quantidade, $validade);

    return $stmt->execute();
}
function edit_cupom($id, $nome, $descricao, $codigo, $tipo, $desconto_porcentagem, $desconto_fixo, $valor_maximo, $quantidade, $validade) {
    global $db_con;

    $stmt = $db_con->prepare("UPDATE cupons SET nome = ?, descricao = ?, codigo = ?, tipo = ?, desconto_porcentagem = ?, desconto_fixo = ?, valor_maximo = ?, quantidade = ?, validade = ? WHERE id = ?");
    $stmt->bind_param("sssssddssi", $nome, $descricao, $codigo, $tipo, $desconto_porcentagem, $desconto_fixo, $valor_maximo, $quantidade, $validade, $id);

    return $stmt->execute();
}

function delete_cupom($id) {
    global $db_con;

    $stmt = $db_con->prepare("DELETE FROM cupons WHERE id = ?");
    $stmt->bind_param("i", $id);

    return $stmt->execute();
}

function conta_pedidos_cupom($codigo, $rel_estabelecimentos_id) {
    global $db_con;

    $stmt = $db_con->prepare("SELECT * FROM pedidos WHERE cupom = ? AND rel_estabelecimentos_id = ?");
    $stmt->bind_param("ss", $codigo, $rel_estabelecimentos_id);
    $stmt->execute();

    $result = $stmt->get_result();
    return $result->num_rows;
}



function new_agendamento($estabelecimento, $sun, $mon, $tue, $wed, $thu, $fri, $sat, $hora, $acao) {
    global $db_con;

    $stmt = $db_con->prepare("INSERT INTO agendamentos (rel_estabelecimentos_id, sun, mon, tue, wed, thu, fri, sat, hora, acao, id) SELECT ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, IFNULL(MAX(id), 0) + 1 FROM agendamentos WHERE rel_estabelecimentos_id = ?");
    $stmt->bind_param("sssssssssss", $estabelecimento, $sun, $mon, $tue, $wed, $thu, $fri, $sat, $hora, $acao, $estabelecimento);

    return $stmt->execute();
}

function edit_agendamento($id, $sun, $mon, $tue, $wed, $thu, $fri, $sat, $hora, $acao) {
    global $db_con;

    $stmt = $db_con->prepare("UPDATE agendamentos SET sun = ?, mon = ?, tue = ?, wed = ?, thu = ?, fri = ?, sat = ?, hora = ?, acao = ? WHERE id = ?");
    $stmt->bind_param("sssssssssi", $sun, $mon, $tue, $wed, $thu, $fri, $sat, $hora, $acao, $id);

    return $stmt->execute();
}

function delete_agendamento($id) {
    global $db_con;

    $stmt = $db_con->prepare("DELETE FROM agendamentos WHERE id = ?");
    $stmt->bind_param("i", $id);

    return $stmt->execute();
}


function new_agendamento_cat( $estabelecimento,$sun,$mon,$tue,$wed,$thu,$fri,$sat,$hora,$acao,$categoria ) {

	global $db_con;
	global $_SESSION;
	
	$id_result = 0;
 // Define ID
    $id_query = "SELECT * FROM `agendamentos_cat` WHERE `rel_estabelecimentos_id` = '$estabelecimento'";
    $id_result = mysqli_num_rows(mysqli_query($db_con, $id_query));
    
    if ($id_result == 0) {
        $first_id = 1;
        if (mysqli_query($db_con, "INSERT INTO agendamentos_cat (rel_estabelecimentos_id, sun, mon, tue, wed, thu, fri, sat, hora, acao, id, catid) VALUES ('$estabelecimento', '$sun', '$mon', '$tue', '$wed', '$thu', '$fri', '$sat', '$hora', '$acao', '$first_id', $categoria);")) {
            return true;
        } else {
            return false;
        }
    } else {
        $new_id = $id_result + 1;
        if (mysqli_query($db_con, "INSERT INTO agendamentos_cat (rel_estabelecimentos_id, sun, mon, tue, wed, thu, fri, sat, hora, acao, id, catid) VALUES ('$estabelecimento', '$sun', '$mon', '$tue', '$wed', '$thu', '$fri', '$sat', '$hora', '$acao', '$new_id', $categoria);")) {
            return true;
        } else {
            return false;
        }
    }
}


function edit_agendamento_cat( $id,$sun,$mon,$tue,$wed,$thu,$fri,$sat,$hora,$acao,$categoria ) {

	global $db_con;

	$updatedquery = "UPDATE agendamentos_cat SET sun = '$sun',mon = '$mon',tue = '$tue',wed = '$wed',thu = '$thu',fri = '$fri',sat = '$sat',hora = '$hora',acao = '$acao',catid = '$categoria' WHERE id = '$id'";

	if( mysqli_query( $db_con, $updatedquery ) ) {

		return true;
	
	} else {

		return false;

	}

}

function delete_agendamento_cat( $id ) {

	global $db_con;

	if( mysqli_query( $db_con, "DELETE FROM agendamentos_cat WHERE id = '$id'") ) {

		return true;

	} else {

		return false;

	}

}
