$(document).ready(function() {
    inicializarScrollCategorias(); // Inicializa o script ao carregar a página

    // Reexecuta o script ao trocar de aba
    $('a[data-toggle="tab"]').on('shown.bs.tab', function() {
        inicializarScrollCategorias(); // Reexecuta ao trocar de aba
    });

    // Função para inicializar o comportamento de rolagem
    function inicializarScrollCategorias() {
        var active = $(".tv-infinite-menu .active");
        if (active.length) {
            var activeWidth = active.width();
            var pos = active.position().left - 15;
            $('.tv-infinite-menu').animate({ scrollLeft: pos }, 500);
        }

        // Botões de rolagem das categorias
        const btnLeft = document.querySelector('.arrow-left');
        const btnRight = document.querySelector('.arrow-right');
        const container = document.querySelector('.tv-infinite-menu');

        if (btnLeft && btnRight && container) {
            btnLeft.addEventListener('click', () => scrollSmoothly('left'));
            btnRight.addEventListener('click', () => scrollSmoothly('right'));
        }

        function scrollSmoothly(direction) {
            const scrollAmount = 200;
            let scrollLeft = direction === 'left' ? -scrollAmount : scrollAmount;
            container.scrollBy({
                top: 0,
                left: scrollLeft,
                behavior: 'smooth'
            });
        }

        // // Verifica o excesso de categorias na carga inicial e redimensionamento
        // verificarExcessoDeCategorias();
        // window.addEventListener('resize', verificarExcessoDeCategorias);

        // function verificarExcessoDeCategorias() {
        //     const container = document.querySelector('.tv-infinite-menu');
        //     const wrapper = document.querySelector('.tv-infinite');

        //     if (container.scrollWidth > wrapper.clientWidth) {
        //         // Aqui não precisa mais alterar o display, o CSS já cuida disso
        //     }
        // }
    }
});
