//fixar menu top scroling
document.addEventListener("DOMContentLoaded", function() {
    // Seleciona os elementos top e navigator
    const topElement = document.querySelector('.top');
    const navigatorElement = document.querySelector('.navigator');
    let lastScrollPosition = 0;

    window.addEventListener('scroll', function() {
        const scrollPosition = window.scrollY;
        const windowHeight = window.innerHeight;

        // Verifica se a rolagem é superior a 10% da altura da janela
        if (scrollPosition > (windowHeight * 0.02)) {
            // Se rolou para baixo
            if (scrollPosition > lastScrollPosition) {
                topElement.classList.remove('sticky');
                navigatorElement.classList.remove('sticky');
            } 
            // Se rolou para cima
            else {
                topElement.classList.add('sticky');
                navigatorElement.classList.add('sticky');
            }
        } else {
            // Se estiver no topo ou perto do topo, remove as classes sticky
            topElement.classList.remove('sticky');
            navigatorElement.classList.remove('sticky');
        }

        // Atualiza a posição da rolagem
        lastScrollPosition = scrollPosition;
    });
});